"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YOU = exports.AT = exports.ASSISTANT = exports.API_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSISTANT = exports.ASSISTANT = _i18n.i18n.translate('xpack.securitySolution.assistant.getComments.assistant', {
  defaultMessage: 'Assistant'
});
const AT = timestamp => _i18n.i18n.translate('xpack.securitySolution.assistant.getComments.at', {
  defaultMessage: 'at: {timestamp}',
  values: {
    timestamp
  }
});
exports.AT = AT;
const YOU = exports.YOU = _i18n.i18n.translate('xpack.securitySolution.assistant.getComments.you', {
  defaultMessage: 'You'
});
const API_ERROR = exports.API_ERROR = _i18n.i18n.translate('xpack.securitySolution.assistant.apiErrorTitle', {
  defaultMessage: 'An error occurred sending your message.'
});