"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WORKFLOW_ANALYSIS_TITLE = exports.WORKFLOW_ANALYSIS_PROMPT = exports.THREAT_INVESTIGATION_GUIDES_TITLE = exports.THREAT_INVESTIGATION_GUIDES_PROMPT = exports.SPL_QUERY_CONVERSION_TITLE = exports.SPL_QUERY_CONVERSION_PROMPT = exports.RULE_CREATION_TITLE = exports.RULE_CREATION_PROMPT = exports.ESQL_QUERY_GENERATION_TITLE = exports.ESQL_QUERY_GENERATION_PROMPT = exports.AUTOMATION_TITLE = exports.AUTOMATION_PROMPT = exports.ALERT_SUMMARIZATION_TITLE = exports.ALERT_SUMMARIZATION_PROMPT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_SUMMARIZATION_TITLE = exports.ALERT_SUMMARIZATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.alertSummarizationTitle', {
  defaultMessage: 'Alert summarization'
});
const ALERT_SUMMARIZATION_PROMPT = exports.ALERT_SUMMARIZATION_PROMPT = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.alertSummarizationPrompt', {
  defaultMessage: 'As an expert in security operations and incident response, provide a breakdown of the attached alert and summarize what it might mean for my organization.'
});
const ESQL_QUERY_GENERATION_TITLE = exports.ESQL_QUERY_GENERATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.esqlQueryGenerationTitle', {
  defaultMessage: 'ES|QL Query Generation'
});
const ESQL_QUERY_GENERATION_PROMPT = exports.ESQL_QUERY_GENERATION_PROMPT = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.esqlQueryGenerationPrompt', {
  defaultMessage: "As an expert user of Elastic Security, please generate an accurate and valid ESQL query to detect the use case below. Your response should be formatted to be able to use immediately in an Elastic Security timeline or detection rule. Take your time with the answer, check your knowledge really well on all the functions I am asking for. For ES|QL answers specifically, you should only ever answer with what's available in your private knowledge. I cannot afford for queries to be inaccurate. Assume I am using the Elastic Common Schema and Elastic Agent.\n\nEnsure the answers are formatted in a way which is easily copyable as a separate code block in markdown."
});
const RULE_CREATION_TITLE = exports.RULE_CREATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.ruleCreationTitle', {
  defaultMessage: 'Query generation'
});
const RULE_CREATION_PROMPT = exports.RULE_CREATION_PROMPT = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.ruleCreationPrompt', {
  defaultMessage: 'As an expert user of Elastic Security, please generate an accurate and valid EQL query to detect the use case below. Your response should be formatted to be able to use immediately in an Elastic Security timeline or detection rule. If Elastic Security already has a prebuilt rule for the use case, or a similar one, please provide a link to it and describe it.'
});
const WORKFLOW_ANALYSIS_TITLE = exports.WORKFLOW_ANALYSIS_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.workflowAnalysisTitle', {
  defaultMessage: 'Workflow suggestions'
});
const WORKFLOW_ANALYSIS_PROMPT = exports.WORKFLOW_ANALYSIS_PROMPT = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.workflowAnalysisPrompt', {
  defaultMessage: 'As an expert user of Elastic Security, please suggest a workflow, with step by step instructions on how to:'
});
const THREAT_INVESTIGATION_GUIDES_TITLE = exports.THREAT_INVESTIGATION_GUIDES_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.threatInvestigationGuidesTitle', {
  defaultMessage: 'Custom data ingestion helper'
});
const THREAT_INVESTIGATION_GUIDES_PROMPT = exports.THREAT_INVESTIGATION_GUIDES_PROMPT = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.threatInvestigationGuidesPrompt', {
  defaultMessage: 'As an expert user of Elastic Security, Elastic Agent, and Ingest pipelines, please list accurate and formatted, step by step instructions on how to ingest the following data using Elastic Agent and Fleet in Kibana and convert it to the Elastic Common Schema:'
});
const SPL_QUERY_CONVERSION_TITLE = exports.SPL_QUERY_CONVERSION_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.splQueryConversionTitle', {
  defaultMessage: 'Query conversion'
});
const SPL_QUERY_CONVERSION_PROMPT = exports.SPL_QUERY_CONVERSION_PROMPT = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.splQueryConversionPrompt', {
  defaultMessage: 'I have the following query from a previous SIEM platform. As an expert user of Elastic Security, please suggest an Elastic EQL equivalent. I should be able to copy it immediately into an Elastic security timeline.'
});
const AUTOMATION_TITLE = exports.AUTOMATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.AutomationTitle', {
  defaultMessage: 'Agent integration advice'
});
const AUTOMATION_PROMPT = exports.AUTOMATION_PROMPT = _i18n.i18n.translate('xpack.securitySolution.assistant.quickPrompts.AutomationPrompt', {
  defaultMessage: 'Which Fleet enabled Elastic Agent integration should I use to collect logs and events from:'
});