"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE_SECURITY_QUICK_PROMPTS = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
var _prompt_contexts = require("../prompt_contexts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Global list of QuickPrompts intended to be used throughout Security Solution.
 * Useful if wanting to see all available QuickPrompts in one place, or if needing
 * to reference when constructing a new chat window to include a QuickPrompt.
 */
const BASE_SECURITY_QUICK_PROMPTS = exports.BASE_SECURITY_QUICK_PROMPTS = [{
  title: i18n.ALERT_SUMMARIZATION_TITLE,
  prompt: i18n.ALERT_SUMMARIZATION_PROMPT,
  color: '#F68FBE',
  categories: [_prompt_contexts.PROMPT_CONTEXT_ALERT_CATEGORY],
  isDefault: true
}, {
  title: i18n.ESQL_QUERY_GENERATION_TITLE,
  prompt: i18n.ESQL_QUERY_GENERATION_PROMPT,
  color: '#9170B8',
  categories: [_prompt_contexts.KNOWLEDGE_BASE_CATEGORY],
  isDefault: true
}, {
  title: i18n.RULE_CREATION_TITLE,
  prompt: i18n.RULE_CREATION_PROMPT,
  categories: [_prompt_contexts.PROMPT_CONTEXT_DETECTION_RULES_CATEGORY],
  color: '#7DDED8',
  isDefault: true
}, {
  title: i18n.WORKFLOW_ANALYSIS_TITLE,
  prompt: i18n.WORKFLOW_ANALYSIS_PROMPT,
  color: '#36A2EF',
  isDefault: true
}, {
  title: i18n.THREAT_INVESTIGATION_GUIDES_TITLE,
  prompt: i18n.THREAT_INVESTIGATION_GUIDES_PROMPT,
  categories: [_prompt_contexts.PROMPT_CONTEXT_EVENT_CATEGORY],
  color: '#F3D371',
  isDefault: true
}, {
  title: i18n.SPL_QUERY_CONVERSION_TITLE,
  prompt: i18n.SPL_QUERY_CONVERSION_PROMPT,
  color: '#BADA55',
  isDefault: true
}, {
  title: i18n.AUTOMATION_TITLE,
  prompt: i18n.AUTOMATION_PROMPT,
  color: '#FFA500',
  isDefault: true
}];