"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommentActions = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/cases-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _assistant_context = require("@kbn/elastic-assistant/impl/assistant_context");
var _kibana = require("../../common/lib/kibana");
var _actions = require("../../common/store/actions");
var _types = require("../../../common/types");
var _helpers = require("../../timelines/components/notes/helpers");
var _store = require("../../timelines/store");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommentActionsComponent = ({
  message,
  isFlyoutMode
}) => {
  var _message$content;
  const toasts = (0, _kibana.useToasts)();
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const isModelEvaluationEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('assistantModelEvaluation');
  const {
    showAssistantOverlay,
    traceOptions
  } = (0, _assistant_context.useAssistantContext)();
  const associateNote = (0, _react.useCallback)(noteId => dispatch(_store.timelineActions.addNote({
    id: _types.TimelineId.active,
    noteId
  })), [dispatch]);
  const updateNote = (0, _react.useCallback)(note => dispatch(_actions.appActions.updateNote({
    note
  })), [dispatch]);
  const content = (_message$content = message.content) !== null && _message$content !== void 0 ? _message$content : '';
  const onAddNoteToTimeline = (0, _react.useCallback)(() => {
    (0, _helpers.updateAndAssociateNode)({
      associateNote,
      newNote: content,
      updateNewNote: () => {},
      updateNote,
      user: '' // TODO: attribute assistant messages
    });
    toasts.addSuccess(i18n.ADDED_NOTE_TO_TIMELINE);
  }, [associateNote, content, toasts, updateNote]);

  // Attach to case support
  const selectCaseModal = cases.hooks.useCasesAddToExistingCaseModal({
    onClose: () => {},
    onSuccess: () => {}
  });
  const onAddToExistingCase = (0, _react.useCallback)(() => {
    if (!isFlyoutMode) {
      showAssistantOverlay({
        showOverlay: false
      });
    }
    selectCaseModal.open({
      getAttachments: () => [{
        comment: content,
        type: _common.AttachmentType.user,
        owner: i18n.ELASTIC_AI_ASSISTANT
      }]
    });
  }, [content, isFlyoutMode, selectCaseModal, showAssistantOverlay]);

  // Note: This feature is behind the `isModelEvaluationEnabled` FF. If ever released, this URL should be configurable
  // as APM data may not go to the same cluster where the Kibana instance is running
  // Links to the experimental trace explorer page
  // Note: There's a bug with URL params being rewritten, so must specify 'query' to filter on transaction id
  // See: https://github.com/elastic/kibana/issues/171368
  const apmTraceLink = message.traceData != null && Object.keys(message.traceData).length > 0 ? `${traceOptions.apmUrl}/traces/explorer/waterfall?comparisonEnabled=false&detailTab=timeline&environment=ENVIRONMENT_ALL&kuery=&query=transaction.id:%20${message.traceData.transactionId}&rangeFrom=now-1y/d&rangeTo=now&showCriticalPath=false&traceId=${message.traceData.traceId}&transactionId=${message.traceData.transactionId}&type=kql&waterfallItemId=` : undefined;

  // Use this link for routing to the services/transactions view which provides a slightly different view
  // const apmTraceLink =
  //     message.traceData != null
  //         ? `${basePath}/app/apm/services/kibana/transactions/view?kuery=&rangeFrom=now-1y&rangeTo=now&environment=ENVIRONMENT_ALL&serviceGroup=&comparisonEnabled=true&traceId=${message.traceData.traceId}&transactionId=${message.traceData.transactionId}&transactionName=POST%20/internal/elastic_assistant/actions/connector/?/_execute&transactionType=request&offset=1d&latencyAggregationType=avg`
  //         : undefined;

  return (
    /*#__PURE__*/
    // APM Trace support is currently behind the Model Evaluation feature flag until wider testing is performed
    _react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, isModelEvaluationEnabled && apmTraceLink != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: i18n.VIEW_APM_TRACE
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.VIEW_APM_TRACE,
      color: "primary",
      iconType: "apmTrace",
      href: apmTraceLink,
      target: '_blank'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: i18n.ADD_NOTE_TO_TIMELINE
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.ADD_MESSAGE_CONTENT_AS_TIMELINE_NOTE,
      color: "primary",
      iconType: "editorComment",
      onClick: onAddNoteToTimeline
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: i18n.ADD_TO_CASE_EXISTING_CASE
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.ADD_TO_CASE_EXISTING_CASE,
      color: "primary",
      iconType: "addDataApp",
      onClick: onAddToExistingCase
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: i18n.COPY_TO_CLIPBOARD
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: content
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.COPY_TO_CLIPBOARD,
      color: "primary",
      iconType: "copyClipboard",
      onClick: copy
    })))))
  );
};
const CommentActions = exports.CommentActions = /*#__PURE__*/_react.default.memo(CommentActionsComponent);