"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assets = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _landing_links = require("@kbn/security-solution-navigation/landing_links");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _eui = require("@elastic/eui");
var _links = require("@kbn/security-solution-navigation/links");
var _nav_links = require("../common/links/nav_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATIONS_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.assets.integrationsCallout.title', {
  defaultMessage: 'Integrations'
});
const INTEGRATIONS_CALLOUT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.assets.integrationsCallout.content', {
  defaultMessage: 'Choose an integration to start collecting and analyzing your data.'
});
const INTEGRATIONS_CALLOUT_BUTTON_TEXT = _i18n.i18n.translate('xpack.securitySolution.assets.integrationsCallout.buttonText', {
  defaultMessage: 'Browse integrations'
});
const Assets = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const link = (0, _nav_links.useRootNavLink)(_securitySolutionNavigation.SecurityPageName.assets);
  const {
    links = [],
    title
  } = link !== null && link !== void 0 ? link : {};
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    restrictWidth: false,
    contentBorder: false,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: title
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksIconsGroups, {
    items: links
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: INTEGRATIONS_CALLOUT_TITLE,
    color: "primary",
    iconType: "cluster",
    style: {
      borderRadius: euiTheme.border.radius.medium
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, INTEGRATIONS_CALLOUT_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    id: _securitySolutionNavigation.ExternalPageName.integrationsSecurity,
    fill: true
  }, INTEGRATIONS_CALLOUT_BUTTON_TEXT))));
};
exports.Assets = Assets;