"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USERS = exports.TRUSTED_APPLICATIONS = exports.TIMELINES = exports.THREAT_INTELLIGENCE = exports.SIEM_RULES = exports.RULES = exports.RESPONSE_ACTIONS_HISTORY = exports.PROTECTION_UPDATES = exports.POLICIES = exports.OVERVIEW = exports.NETWORK = exports.MANAGE = exports.KUBERNETES = exports.HOST_ISOLATION_EXCEPTIONS = exports.HOSTS = exports.GETTING_STARTED = exports.FINDINGS = exports.EXPLORE = exports.EXCEPTIONS = exports.EVENT_FILTERS = exports.ENTITY_ANALYTICS_RISK_SCORE = exports.ENTITY_ANALYTICS = exports.ENDPOINTS = exports.DETECTION_RESPONSE = exports.DETECT = exports.DATA_QUALITY = exports.DASHBOARDS = exports.CREATE_NEW_RULE = exports.COVERAGE_OVERVIEW = exports.CASE = exports.BLOCKLIST = exports.ATTACK_DISCOVERY = exports.ASSET_CRITICALITY = exports.ALERTS = exports.ADMINISTRATION = exports.ADD_RULES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OVERVIEW = exports.OVERVIEW = _i18n.i18n.translate('xpack.securitySolution.navigation.overview', {
  defaultMessage: 'Overview'
});
const DATA_QUALITY = exports.DATA_QUALITY = _i18n.i18n.translate('xpack.securitySolution.navigation.ecsDataQualityDashboard', {
  defaultMessage: 'Data Quality'
});
const ENTITY_ANALYTICS_RISK_SCORE = exports.ENTITY_ANALYTICS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.navigation.entityRiskScore', {
  defaultMessage: 'Entity Risk Score'
});
const ASSET_CRITICALITY = exports.ASSET_CRITICALITY = _i18n.i18n.translate('xpack.securitySolution.navigation.assetCriticality', {
  defaultMessage: 'Asset criticality'
});
const DETECTION_RESPONSE = exports.DETECTION_RESPONSE = _i18n.i18n.translate('xpack.securitySolution.navigation.detectionResponse', {
  defaultMessage: 'Detection & Response'
});
const ENTITY_ANALYTICS = exports.ENTITY_ANALYTICS = _i18n.i18n.translate('xpack.securitySolution.navigation.entityAnalytics', {
  defaultMessage: 'Entity Analytics'
});
const HOSTS = exports.HOSTS = _i18n.i18n.translate('xpack.securitySolution.navigation.hosts', {
  defaultMessage: 'Hosts'
});
const GETTING_STARTED = exports.GETTING_STARTED = _i18n.i18n.translate('xpack.securitySolution.navigation.gettingStarted', {
  defaultMessage: 'Get started'
});
const DASHBOARDS = exports.DASHBOARDS = _i18n.i18n.translate('xpack.securitySolution.navigation.dashboards', {
  defaultMessage: 'Dashboards'
});
const COVERAGE_OVERVIEW = exports.COVERAGE_OVERVIEW = _i18n.i18n.translate('xpack.securitySolution.navigation.coverageOverviewDashboard', {
  defaultMessage: 'MITRE ATT&CK\u00AE Coverage'
});
const NETWORK = exports.NETWORK = _i18n.i18n.translate('xpack.securitySolution.navigation.network', {
  defaultMessage: 'Network'
});
const USERS = exports.USERS = _i18n.i18n.translate('xpack.securitySolution.navigation.users', {
  defaultMessage: 'Users'
});
const KUBERNETES = exports.KUBERNETES = _i18n.i18n.translate('xpack.securitySolution.navigation.kubernetes', {
  defaultMessage: 'Kubernetes'
});
const RULES = exports.RULES = _i18n.i18n.translate('xpack.securitySolution.navigation.rules', {
  defaultMessage: 'Rules'
});
const SIEM_RULES = exports.SIEM_RULES = _i18n.i18n.translate('xpack.securitySolution.navigation.detectionRules', {
  defaultMessage: 'Detection rules (SIEM)'
});
const ADD_RULES = exports.ADD_RULES = _i18n.i18n.translate('xpack.securitySolution.navigation.addRules', {
  defaultMessage: 'Add Rules'
});
const EXCEPTIONS = exports.EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.navigation.exceptions', {
  defaultMessage: 'Shared exception lists'
});
const ALERTS = exports.ALERTS = _i18n.i18n.translate('xpack.securitySolution.navigation.alerts', {
  defaultMessage: 'Alerts'
});
const ATTACK_DISCOVERY = exports.ATTACK_DISCOVERY = _i18n.i18n.translate('xpack.securitySolution.navigation.attackDiscovery', {
  defaultMessage: 'Attack discovery'
});
const TIMELINES = exports.TIMELINES = _i18n.i18n.translate('xpack.securitySolution.navigation.timelines', {
  defaultMessage: 'Timelines'
});
const CASE = exports.CASE = _i18n.i18n.translate('xpack.securitySolution.navigation.case', {
  defaultMessage: 'Cases'
});
const ADMINISTRATION = exports.ADMINISTRATION = _i18n.i18n.translate('xpack.securitySolution.navigation.administration', {
  defaultMessage: 'Administration'
});
const ENDPOINTS = exports.ENDPOINTS = _i18n.i18n.translate('xpack.securitySolution.search.administration.endpoints', {
  defaultMessage: 'Endpoints'
});
const POLICIES = exports.POLICIES = _i18n.i18n.translate('xpack.securitySolution.navigation.administration.policies', {
  defaultMessage: 'Policies'
});
const TRUSTED_APPLICATIONS = exports.TRUSTED_APPLICATIONS = _i18n.i18n.translate('xpack.securitySolution.search.administration.trustedApps', {
  defaultMessage: 'Trusted applications'
});
const EVENT_FILTERS = exports.EVENT_FILTERS = _i18n.i18n.translate('xpack.securitySolution.search.administration.eventFilters', {
  defaultMessage: 'Event filters'
});
const HOST_ISOLATION_EXCEPTIONS = exports.HOST_ISOLATION_EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.search.administration.hostIsolationExceptions', {
  defaultMessage: 'Host isolation exceptions'
});
const DETECT = exports.DETECT = _i18n.i18n.translate('xpack.securitySolution.navigation.detect', {
  defaultMessage: 'Detect'
});
const FINDINGS = exports.FINDINGS = _i18n.i18n.translate('xpack.securitySolution.navigation.findings', {
  defaultMessage: 'Findings'
});
const EXPLORE = exports.EXPLORE = _i18n.i18n.translate('xpack.securitySolution.navigation.explore', {
  defaultMessage: 'Explore'
});
const MANAGE = exports.MANAGE = _i18n.i18n.translate('xpack.securitySolution.navigation.manage', {
  defaultMessage: 'Manage'
});
const BLOCKLIST = exports.BLOCKLIST = _i18n.i18n.translate('xpack.securitySolution.navigation.blocklist', {
  defaultMessage: 'Blocklist'
});
const RESPONSE_ACTIONS_HISTORY = exports.RESPONSE_ACTIONS_HISTORY = _i18n.i18n.translate('xpack.securitySolution.navigation.responseActionsHistory', {
  defaultMessage: 'Response actions history'
});
const PROTECTION_UPDATES = exports.PROTECTION_UPDATES = _i18n.i18n.translate('xpack.securitySolution.navigation.protectionUpdates', {
  defaultMessage: 'Protection updates'
});
const CREATE_NEW_RULE = exports.CREATE_NEW_RULE = _i18n.i18n.translate('xpack.securitySolution.navigation.newRuleTitle', {
  defaultMessage: 'Create new rule'
});
const THREAT_INTELLIGENCE = exports.THREAT_INTELLIGENCE = _i18n.i18n.translate('xpack.securitySolution.navigation.threatIntelligence', {
  defaultMessage: 'Intelligence'
});