"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBreadcrumbHidden = exports.getSolutionPageNameFromNavLinkId = exports.getNavLinkIdFromSolutionPageName = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNavLinkIdFromSolutionPageName = solutionPageName => {
  const cleanId = solutionPageName.replace(/\/(.*)$/, ''); // remove any trailing path
  const fullId = cleanId.includes(':') ? cleanId : `${_common.APP_UI_ID}:${cleanId}`; // add the Security appId if not defined
  return fullId.replace(/:$/, ''); // clean trailing separator to app root links to contain the appId alone
};
exports.getNavLinkIdFromSolutionPageName = getNavLinkIdFromSolutionPageName;
const getSolutionPageNameFromNavLinkId = navLinkId => {
  const cleanId = navLinkId.includes(':') ? navLinkId : `${navLinkId}:`; // add trailing separator to app root links that contain the appId alone
  const fullId = cleanId.replace(`${_common.APP_UI_ID}:`, ''); // remove Security appId if present
  return fullId;
};

// We need to hide breadcrumbs for some pages (tabs) because they appear duplicated.
// These breadcrumbs are incorrectly processed as trailing breadcrumbs in SecuritySolution, because of `SpyRoute` architecture limitations.
// They are navLinks tree with a SecurityPageName, so they should be treated as leading breadcrumbs in ESS as well.
// TODO: Improve the breadcrumbs logic in `use_breadcrumbs_nav` to avoid this workaround.
exports.getSolutionPageNameFromNavLinkId = getSolutionPageNameFromNavLinkId;
const HIDDEN_BREADCRUMBS = new Set([_securitySolutionNavigation.SecurityPageName.networkFlows, _securitySolutionNavigation.SecurityPageName.networkDns, _securitySolutionNavigation.SecurityPageName.networkHttp, _securitySolutionNavigation.SecurityPageName.networkTls, _securitySolutionNavigation.SecurityPageName.networkAnomalies, _securitySolutionNavigation.SecurityPageName.networkEvents, _securitySolutionNavigation.SecurityPageName.usersAll, _securitySolutionNavigation.SecurityPageName.usersAuthentications, _securitySolutionNavigation.SecurityPageName.usersAnomalies, _securitySolutionNavigation.SecurityPageName.usersRisk, _securitySolutionNavigation.SecurityPageName.usersEvents, _securitySolutionNavigation.SecurityPageName.hostsAll, _securitySolutionNavigation.SecurityPageName.hostsUncommonProcesses, _securitySolutionNavigation.SecurityPageName.hostsAnomalies, _securitySolutionNavigation.SecurityPageName.hostsEvents, _securitySolutionNavigation.SecurityPageName.hostsRisk, _securitySolutionNavigation.SecurityPageName.hostsSessions]);
const isBreadcrumbHidden = id => HIDDEN_BREADCRUMBS.has(id) || ( /* management sub-pages set their breadcrumbs themselves, the main Management breadcrumb is configured with our navigationTree definition */
id.startsWith(_securitySolutionNavigation.ExternalPageName.management) && id !== _securitySolutionNavigation.ExternalPageName.management);
exports.isBreadcrumbHidden = isBreadcrumbHidden;