"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settingsNavLinks = exports.createSettingsLinksFromManage = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var i18n = _interopRequireWildcard(require("./settings_translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSettingsLinksFromManage = manageLink => {
  var _manageLink$links;
  const entityAnalyticsLink = (_manageLink$links = manageLink.links) === null || _manageLink$links === void 0 ? void 0 : _manageLink$links.find(({
    id
  }) => id === _securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement);
  return entityAnalyticsLink ? [{
    ...entityAnalyticsLink,
    sideNavDisabled: true // Link disabled from the side nav but configured in the navigationTree (breadcrumbs). It is displayed in the management cards landing.
  }] : [];
};
exports.createSettingsLinksFromManage = createSettingsLinksFromManage;
const settingsNavLinks = exports.settingsNavLinks = [{
  id: _securitySolutionNavigation.ExternalPageName.management,
  title: i18n.MANAGEMENT_TITLE,
  isFooterLink: true
}, {
  id: _securitySolutionNavigation.ExternalPageName.integrationsSecurity,
  title: i18n.INTEGRATIONS_TITLE,
  isFooterLink: true
}, {
  id: _securitySolutionNavigation.ExternalPageName.maps,
  title: i18n.MAPS_TITLE,
  description: i18n.MAPS_DESCRIPTION,
  landingIcon: 'graphApp',
  disabled: true // Link disabled from the side nav but configured in the navigationTree (breadcrumbs). It is displayed in the management cards landing.
}, {
  id: _securitySolutionNavigation.ExternalPageName.visualize,
  title: i18n.VISUALIZE_TITLE,
  description: i18n.VISUALIZE_DESCRIPTION,
  landingIcon: 'visualizeApp',
  disabled: true // Link disabled from the side nav but configured in the navigationTree (breadcrumbs). It is displayed in the management cards landing.
}];