"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlNavLinks = exports.mlNavCategories = exports.mlAppLink = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("../../../../../common/constants");
var _common = require("../../../../../common");
var _lazy_icons = require("./lazy_icons");
var i18n = _interopRequireWildcard(require("./ml_translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// appLinks configures the Security Solution pages links
const mlAppLink = exports.mlAppLink = {
  id: _securitySolutionNavigation.SecurityPageName.mlLanding,
  title: i18n.ML_TITLE,
  path: _constants.MACHINE_LEARNING_PATH,
  capabilities: [`${_common.SERVER_APP_ID}.show`],
  globalSearchKeywords: [i18n.ML_KEYWORD],
  hideTimeline: true,
  skipUrlState: true,
  links: [] // no security internal links
};
const mlNavCategories = exports.mlNavCategories = [{
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.ExternalPageName.mlOverview, _securitySolutionNavigation.ExternalPageName.mlNotifications, _securitySolutionNavigation.ExternalPageName.mlMemoryUsage]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.ANOMALY_DETECTION_CATEGORY,
  linkIds: [_securitySolutionNavigation.ExternalPageName.mlAnomalyDetection, _securitySolutionNavigation.ExternalPageName.mlAnomalyExplorer, _securitySolutionNavigation.ExternalPageName.mlSingleMetricViewer, _securitySolutionNavigation.ExternalPageName.mlSettings]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.DATA_FRAME_ANALYTICS_CATEGORY,
  linkIds: [_securitySolutionNavigation.ExternalPageName.mlDataFrameAnalytics, _securitySolutionNavigation.ExternalPageName.mlResultExplorer, _securitySolutionNavigation.ExternalPageName.mlAnalyticsMap]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.MODEL_MANAGEMENT_CATEGORY,
  linkIds: [_securitySolutionNavigation.ExternalPageName.mlNodesOverview]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.DATA_VISUALIZER_CATEGORY,
  linkIds: [_securitySolutionNavigation.ExternalPageName.mlFileUpload, _securitySolutionNavigation.ExternalPageName.mlIndexDataVisualizer, _securitySolutionNavigation.ExternalPageName.mlDataDrift]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.AIOPS_LABS_CATEGORY,
  linkIds: [_securitySolutionNavigation.ExternalPageName.mlExplainLogRateSpikes, _securitySolutionNavigation.ExternalPageName.mlLogPatternAnalysis, _securitySolutionNavigation.ExternalPageName.mlChangePointDetections]
}];

// navLinks define the navigation links for the Security Solution pages and External pages as well
const mlNavLinks = exports.mlNavLinks = [{
  id: _securitySolutionNavigation.ExternalPageName.mlOverview,
  title: i18n.OVERVIEW_TITLE,
  landingIcon: _lazy_icons.IconLensLazy,
  description: i18n.OVERVIEW_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlNotifications,
  title: i18n.NOTIFICATIONS_TITLE,
  landingIcon: _lazy_icons.IconMarketingLazy,
  description: i18n.NOTIFICATIONS_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlMemoryUsage,
  title: i18n.MEMORY_USAGE_TITLE,
  landingIcon: _lazy_icons.IconInfraLazy,
  description: i18n.MEMORY_USAGE_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlAnomalyDetection,
  title: i18n.ANOMALY_DETECTION_TITLE,
  landingIcon: _lazy_icons.IconJobsLazy,
  description: i18n.ANOMALY_DETECTION_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlAnomalyExplorer,
  title: i18n.ANOMALY_EXPLORER_TITLE,
  landingIcon: _lazy_icons.IconKeywordLazy,
  description: i18n.ANOMALY_EXPLORER_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlSingleMetricViewer,
  title: i18n.SINGLE_METRIC_VIEWER_TITLE,
  landingIcon: _lazy_icons.IconVisualizationLazy,
  description: i18n.SINGLE_METRIC_VIEWER_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlSettings,
  title: i18n.SETTINGS_TITLE,
  landingIcon: _lazy_icons.IconSettingsLazy,
  description: i18n.SETTINGS_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlDataFrameAnalytics,
  title: i18n.DATA_FRAME_ANALYTICS_TITLE,
  landingIcon: _lazy_icons.IconJobsLazy,
  description: i18n.DATA_FRAME_ANALYTICS_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlResultExplorer,
  title: i18n.RESULT_EXPLORER_TITLE,
  landingIcon: _lazy_icons.IconDashboardLazy,
  description: i18n.RESULT_EXPLORER_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlAnalyticsMap,
  title: i18n.ANALYTICS_MAP_TITLE,
  landingIcon: _lazy_icons.IconChartArrowLazy,
  description: i18n.ANALYTICS_MAP_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlNodesOverview,
  title: i18n.NODES_OVERVIEW_TITLE,
  landingIcon: _lazy_icons.IconManagerLazy,
  description: i18n.NODES_OVERVIEW_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlFileUpload,
  title: i18n.FILE_UPLOAD_TITLE,
  landingIcon: _lazy_icons.IconFilebeatLazy,
  description: i18n.FILE_UPLOAD_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlIndexDataVisualizer,
  title: i18n.INDEX_DATA_VISUALIZER_TITLE,
  landingIcon: _lazy_icons.IconDataViewLazy,
  description: i18n.INDEX_DATA_VISUALIZER_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlDataDrift,
  title: i18n.DATA_DRIFT_TITLE,
  landingIcon: _lazy_icons.IconRapidBarGraphLazy,
  description: i18n.DATA_DRIFT_TITLE
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlExplainLogRateSpikes,
  title: i18n.LOG_RATE_ANALYSIS_TITLE,
  landingIcon: _lazy_icons.IconFilebeatChartLazy,
  description: i18n.LOG_RATE_ANALYSIS_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlLogPatternAnalysis,
  title: i18n.LOG_PATTERN_ANALYSIS_TITLE,
  landingIcon: _lazy_icons.IconReplicationLazy,
  description: i18n.LOG_PATTERN_ANALYSIS_DESC
}, {
  id: _securitySolutionNavigation.ExternalPageName.mlChangePointDetections,
  title: i18n.CHANGE_POINT_DETECTIONS_TITLE,
  landingIcon: _lazy_icons.IconIntuitiveLazy,
  description: i18n.CHANGE_POINT_DETECTIONS_DESC
}];