"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAssetsLinkFromManage = exports.assetsNavLinks = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("../../../../../common/constants");
var _common = require("../../../../../common");
var _lazy_icons = require("./lazy_icons");
var i18n = _interopRequireWildcard(require("./assets_translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// appLinks configures the Security Solution pages links
const assetsAppLink = {
  id: _securitySolutionNavigation.SecurityPageName.assets,
  title: i18n.ASSETS_TITLE,
  path: _constants.ASSETS_PATH,
  capabilities: [`${_common.SERVER_APP_ID}.show`],
  hideTimeline: true,
  skipUrlState: true,
  links: [] // endpoints and cloudDefend links are added in createAssetsLinkFromManage
};

// TODO: define this Cloud Defend app link in security_solution plugin
const assetsCloudDefendAppLink = {
  id: _securitySolutionNavigation.SecurityPageName.cloudDefend,
  title: i18n.CLOUD_DEFEND_TITLE,
  description: i18n.CLOUD_DEFEND_DESCRIPTION,
  path: _constants.CLOUD_DEFEND_PATH,
  capabilities: [`${_common.SERVER_APP_ID}.show`],
  landingIcon: _lazy_icons.IconEcctlLazy,
  isBeta: true,
  hideTimeline: true,
  links: [] // cloudDefendPolicies link is added in createAssetsLinkFromManage
};
const createAssetsLinkFromManage = manageLink => {
  var _manageLink$categorie, _manageLink$categorie2, _manageLink$categorie3, _manageLink$categorie4, _manageLink$links, _manageLink$links$fil, _manageLink$links2, _manageLink$links3;
  const assetsSubLinks = [];

  // Get endpoint sub links from the manage categories
  const endpointsSubLinkIds = (_manageLink$categorie = (_manageLink$categorie2 = manageLink.categories) === null || _manageLink$categorie2 === void 0 ? void 0 : (_manageLink$categorie3 = _manageLink$categorie2.find(({
    linkIds
  }) => linkIds === null || linkIds === void 0 ? void 0 : linkIds.includes(_securitySolutionNavigation.SecurityPageName.endpoints))) === null || _manageLink$categorie3 === void 0 ? void 0 : (_manageLink$categorie4 = _manageLink$categorie3.linkIds) === null || _manageLink$categorie4 === void 0 ? void 0 : _manageLink$categorie4.filter(linkId => linkId !== _securitySolutionNavigation.SecurityPageName.endpoints)) !== null && _manageLink$categorie !== void 0 ? _manageLink$categorie : [];
  const endpointsLink = (_manageLink$links = manageLink.links) === null || _manageLink$links === void 0 ? void 0 : _manageLink$links.find(({
    id
  }) => id === _securitySolutionNavigation.SecurityPageName.endpoints);
  const endpointsSubLinks = (_manageLink$links$fil = (_manageLink$links2 = manageLink.links) === null || _manageLink$links2 === void 0 ? void 0 : _manageLink$links2.filter(({
    id
  }) => endpointsSubLinkIds.includes(id))) !== null && _manageLink$links$fil !== void 0 ? _manageLink$links$fil : [];
  if (endpointsLink) {
    // Add main endpoints link with all endpoints sub links
    assetsSubLinks.push({
      ...endpointsLink,
      links: endpointsSubLinks
    });
  }
  const cloudPoliciesLink = (_manageLink$links3 = manageLink.links) === null || _manageLink$links3 === void 0 ? void 0 : _manageLink$links3.find(({
    id
  }) => id === _securitySolutionNavigation.SecurityPageName.cloudDefendPolicies);
  if (cloudPoliciesLink) {
    // Add cloud defend policies link as cloud defend sub link
    assetsSubLinks.push({
      ...assetsCloudDefendAppLink,
      links: [cloudPoliciesLink]
    });
  }
  return {
    ...assetsAppLink,
    links: assetsSubLinks
  };
};

// navLinks define the navigation links for the Security Solution pages and External pages as well
exports.createAssetsLinkFromManage = createAssetsLinkFromManage;
const assetsNavLinks = exports.assetsNavLinks = [{
  id: _securitySolutionNavigation.ExternalPageName.fleet,
  title: i18n.FLEET_TITLE,
  landingIcon: _lazy_icons.IconFleetLazy,
  description: i18n.FLEET_DESCRIPTION,
  links: [{
    id: _securitySolutionNavigation.ExternalPageName.fleetAgents,
    title: i18n.FLEET_AGENTS_TITLE
  }, {
    id: _securitySolutionNavigation.ExternalPageName.fleetPolicies,
    title: i18n.FLEET_POLICIES_TITLE
  }, {
    id: _securitySolutionNavigation.ExternalPageName.fleetEnrollmentTokens,
    title: i18n.FLEET_ENROLLMENT_TOKENS_TITLE
  }, {
    id: _securitySolutionNavigation.ExternalPageName.fleetUninstallTokens,
    title: i18n.FLEET_UNINSTALL_TOKENS_TITLE
  }, {
    id: _securitySolutionNavigation.ExternalPageName.fleetDataStreams,
    title: i18n.FLEET_DATA_STREAMS_TITLE
  }, {
    id: _securitySolutionNavigation.ExternalPageName.fleetSettings,
    title: i18n.FLEET_SETTINGS_TITLE
  }]
}];