"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToggleUserAssetFieldCellActionFactory = void 0;
var _i18n = require("@kbn/i18n");
var _cellActions = require("@kbn/cell-actions");
var _model = require("../../../explore/users/store/model");
var _store = require("../../../explore/users/store");
var _utils = require("../../utils");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON = 'listAdd';
const TOGGLE_FIELD = _i18n.i18n.translate('xpack.securitySolution.actions.toggleFieldToAssetTable.label', {
  defaultMessage: 'Toggle field in asset table'
});
const createToggleUserAssetFieldCellActionFactory = exports.createToggleUserAssetFieldCellActionFactory = (0, _cellActions.createCellActionFactory)(({
  store
}) => ({
  type: _constants.SecurityCellActionType.TOGGLE_COLUMN,
  getIconType: () => ICON,
  getDisplayName: () => TOGGLE_FIELD,
  getDisplayNameTooltip: ({
    data
  }) => TOGGLE_FIELD,
  isCompatible: async ({
    data,
    metadata
  }) => {
    var _data$;
    const field = (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.field;
    return data.length === 1 && (0, _utils.fieldHasCellActions)(field.name) && !(metadata !== null && metadata !== void 0 && metadata.isObjectArray) && !!(metadata !== null && metadata !== void 0 && metadata.scopeId) && Object.values(_model.UserAssetTableType).includes(metadata === null || metadata === void 0 ? void 0 : metadata.scopeId);
  },
  execute: async ({
    metadata,
    data
  }) => {
    var _data$2;
    const field = (_data$2 = data[0]) === null || _data$2 === void 0 ? void 0 : _data$2.field;
    const scopeId = metadata === null || metadata === void 0 ? void 0 : metadata.scopeId;
    if (!scopeId) return;
    const {
      fields
    } = _store.usersSelectors.selectUserAssetTableById(store.getState(), scopeId);
    if (fields.some(f => f === field.name)) {
      store.dispatch(_store.usersActions.removeUserAssetTableField({
        fieldName: field.name,
        tableId: scopeId
      }));
    } else {
      store.dispatch(_store.usersActions.addUserAssetTableField({
        fieldName: field.name,
        tableId: scopeId
      }));
    }
  }
}));