"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilterOutCellActionFactory = void 0;
var _cellActions = require("@kbn/cell-actions");
var _utils = require("@kbn/cell-actions/src/actions/utils");
var _translations = require("@kbn/cell-actions/src/actions/translations");
var _utils2 = require("../../utils");
var _helpers = require("../../../helpers");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFilterOutCellActionFactory = ({
  services
}) => {
  const {
    filterManager
  } = services.data.query;
  const {
    notifications
  } = services;
  const genericFilterOutActionFactory = (0, _cellActions.createFilterOutActionFactory)({
    filterManager,
    notifications
  });
  return genericFilterOutActionFactory.combine({
    type: _constants.SecurityCellActionType.FILTER,
    isCompatible: async ({
      data
    }) => {
      var _data$;
      const field = (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.field;
      return data.length === 1 &&
      // TODO Add support for multiple values
      (0, _utils2.fieldHasCellActions)(field.name) && (0, _utils.isTypeSupportedByDefaultActions)(field.type);
    },
    execute: async ({
      data,
      metadata
    }) => {
      var _data$2, _data$3;
      const fieldName = (_data$2 = data[0]) === null || _data$2 === void 0 ? void 0 : _data$2.field.name;
      const rawValue = (_data$3 = data[0]) === null || _data$3 === void 0 ? void 0 : _data$3.value;
      const dataViewId = metadata === null || metadata === void 0 ? void 0 : metadata.dataViewId;
      const value = (0, _utils.filterOutNullableValues)((0, _utils.valueToArray)(rawValue));
      if (!(0, _utils.isValueSupportedByDefaultActions)(value)) {
        notifications.toasts.addWarning({
          title: _translations.ACTION_INCOMPATIBLE_VALUE_WARNING
        });
        return;
      }
      if (!fieldName) return;

      // if negateFilters is true we have to perform the opposite operation, we can just execute filterIn with the same params
      const addFilter = (metadata === null || metadata === void 0 ? void 0 : metadata.negateFilters) === true ? _cellActions.addFilterIn : _cellActions.addFilterOut;
      if (metadata !== null && metadata !== void 0 && metadata.scopeId && (0, _helpers.isTimelineScope)(metadata.scopeId)) {
        addFilter({
          filterManager: services.timelineFilterManager,
          fieldName,
          value,
          dataViewId
        });
      } else {
        addFilter({
          filterManager,
          fieldName,
          value,
          dataViewId
        });
      }
    }
  });
};
exports.createFilterOutCellActionFactory = createFilterOutCellActionFactory;