"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCopyToClipboardCellActionFactory = void 0;
var _cellActions = require("@kbn/cell-actions");
var _utils = require("../../utils");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCopyToClipboardCellActionFactory = ({
  services
}) => {
  const {
    notifications
  } = services;
  const genericCopyToClipboardActionFactory = (0, _cellActions.createCopyToClipboardActionFactory)({
    notifications
  });
  return genericCopyToClipboardActionFactory.combine({
    type: _constants.SecurityCellActionType.COPY,
    isCompatible: async ({
      data
    }) => {
      var _data$;
      const field = (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.field;
      return (0, _utils.fieldHasCellActions)(field.name);
    }
  });
};
exports.createCopyToClipboardCellActionFactory = createCopyToClipboardCellActionFactory;