"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "RiskQueries", {
  enumerable: true,
  get: function () {
    return _search_strategy.RiskQueries;
  }
});
Object.defineProperty(exports, "RiskScoreEntity", {
  enumerable: true,
  get: function () {
    return _risk_engine.RiskScoreEntity;
  }
});
exports.getUserRiskIndex = exports.getHostRiskIndex = exports.buildUserNamesFilter = exports.buildHostNamesFilter = exports.buildEntityNameFilter = void 0;
var _constants = require("../../../../constants");
var _risk_engine = require("../../../../entity_analytics/risk_engine");
var _search_strategy = require("../../../../api/search_strategy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Make sure this aligns with the index in step 6, 9 in
 * prebuilt_dev_tool_content/console_templates/enable_host_risk_score.console
 */
const getHostRiskIndex = (spaceId, onlyLatest = true, isNewRiskScoreModuleInstalled) => {
  if (isNewRiskScoreModuleInstalled) {
    return onlyLatest ? (0, _risk_engine.getRiskScoreLatestIndex)(spaceId) : (0, _risk_engine.getRiskScoreTimeSeriesIndex)(spaceId);
  } else {
    return `${_constants.RISKY_HOSTS_INDEX_PREFIX}${onlyLatest ? 'latest_' : ''}${spaceId}`;
  }
};
exports.getHostRiskIndex = getHostRiskIndex;
const getUserRiskIndex = (spaceId, onlyLatest = true, isNewRiskScoreModuleInstalled) => {
  if (isNewRiskScoreModuleInstalled) {
    return onlyLatest ? (0, _risk_engine.getRiskScoreLatestIndex)(spaceId) : (0, _risk_engine.getRiskScoreTimeSeriesIndex)(spaceId);
  } else {
    return `${_constants.RISKY_USERS_INDEX_PREFIX}${onlyLatest ? 'latest_' : ''}${spaceId}`;
  }
};
exports.getUserRiskIndex = getUserRiskIndex;
const buildHostNamesFilter = hostNames => {
  return {
    terms: {
      'host.name': hostNames
    }
  };
};
exports.buildHostNamesFilter = buildHostNamesFilter;
const buildUserNamesFilter = userNames => {
  return {
    terms: {
      'user.name': userNames
    }
  };
};
exports.buildUserNamesFilter = buildUserNamesFilter;
const buildEntityNameFilter = (entityNames, riskEntity) => {
  return riskEntity === _risk_engine.RiskScoreEntity.host ? {
    terms: {
      'host.name': entityNames
    }
  } : {
    terms: {
      'user.name': entityNames
    }
  };
};
exports.buildEntityNameFilter = buildEntityNameFilter;