"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreFields = exports.EMPTY_SEVERITY_COUNT = void 0;
Object.defineProperty(exports, "RiskSeverity", {
  enumerable: true,
  get: function () {
    return _risk_engine.RiskLevels;
  }
});
exports.isUserRiskScore = void 0;
var _risk_engine = require("../../../../entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RiskScoreFields = exports.RiskScoreFields = /*#__PURE__*/function (RiskScoreFields) {
  RiskScoreFields["timestamp"] = "@timestamp";
  RiskScoreFields["hostName"] = "host.name";
  RiskScoreFields["hostRiskScore"] = "host.risk.calculated_score_norm";
  RiskScoreFields["hostRisk"] = "host.risk.calculated_level";
  RiskScoreFields["userName"] = "user.name";
  RiskScoreFields["userRiskScore"] = "user.risk.calculated_score_norm";
  RiskScoreFields["userRisk"] = "user.risk.calculated_level";
  RiskScoreFields["alertsCount"] = "alertsCount";
  return RiskScoreFields;
}({});
const isUserRiskScore = risk => 'user' in risk;
exports.isUserRiskScore = isUserRiskScore;
const EMPTY_SEVERITY_COUNT = exports.EMPTY_SEVERITY_COUNT = {
  [_risk_engine.RiskLevels.critical]: 0,
  [_risk_engine.RiskLevels.high]: 0,
  [_risk_engine.RiskLevels.low]: 0,
  [_risk_engine.RiskLevels.moderate]: 0,
  [_risk_engine.RiskLevels.unknown]: 0
};