"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prebuiltSavedObjectsBulkDeleteUrl = exports.prebuiltSavedObjectsBulkCreateUrl = exports.devToolPrebuiltContentUrl = exports.RISK_SCORE_PREVIEW_URL = exports.RISK_SCORE_DELETE_STORED_SCRIPT = exports.RISK_SCORE_DELETE_INDICES = exports.RISK_SCORE_CREATE_STORED_SCRIPT = exports.RISK_SCORE_CREATE_INDEX = exports.RISK_SCORE_CALCULATION_URL = exports.RISK_ENGINE_PUBLIC_PREFIX = exports.PREBUILT_SAVED_OBJECTS_BULK_DELETE = exports.PREBUILT_SAVED_OBJECTS_BULK_CREATE = exports.INTERNAL_RISK_SCORE_URL = exports.DEV_TOOL_PREBUILT_CONTENT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Public Risk Score routes
 */
const RISK_ENGINE_PUBLIC_PREFIX = exports.RISK_ENGINE_PUBLIC_PREFIX = '/api/risk_scores';
const RISK_SCORE_CALCULATION_URL = exports.RISK_SCORE_CALCULATION_URL = `${RISK_ENGINE_PUBLIC_PREFIX}/calculation`;

/**
 * Internal Risk Score routes
 */
const INTERNAL_RISK_SCORE_URL = exports.INTERNAL_RISK_SCORE_URL = '/internal/risk_score';
const DEV_TOOL_PREBUILT_CONTENT = exports.DEV_TOOL_PREBUILT_CONTENT = `${INTERNAL_RISK_SCORE_URL}/prebuilt_content/dev_tool/{console_id}`;
const devToolPrebuiltContentUrl = (spaceId, consoleId) => `/s/${spaceId}${INTERNAL_RISK_SCORE_URL}/prebuilt_content/dev_tool/${consoleId}`;
exports.devToolPrebuiltContentUrl = devToolPrebuiltContentUrl;
const PREBUILT_SAVED_OBJECTS_BULK_CREATE = exports.PREBUILT_SAVED_OBJECTS_BULK_CREATE = `${INTERNAL_RISK_SCORE_URL}/prebuilt_content/saved_objects/_bulk_create/{template_name}`;
const prebuiltSavedObjectsBulkCreateUrl = templateName => `${INTERNAL_RISK_SCORE_URL}/prebuilt_content/saved_objects/_bulk_create/${templateName}`;
exports.prebuiltSavedObjectsBulkCreateUrl = prebuiltSavedObjectsBulkCreateUrl;
const PREBUILT_SAVED_OBJECTS_BULK_DELETE = exports.PREBUILT_SAVED_OBJECTS_BULK_DELETE = `${INTERNAL_RISK_SCORE_URL}/prebuilt_content/saved_objects/_bulk_delete/{template_name}`;
const prebuiltSavedObjectsBulkDeleteUrl = templateName => `${INTERNAL_RISK_SCORE_URL}/prebuilt_content/saved_objects/_bulk_delete/${templateName}`;
exports.prebuiltSavedObjectsBulkDeleteUrl = prebuiltSavedObjectsBulkDeleteUrl;
const RISK_SCORE_CREATE_INDEX = exports.RISK_SCORE_CREATE_INDEX = `${INTERNAL_RISK_SCORE_URL}/indices/create`;
const RISK_SCORE_DELETE_INDICES = exports.RISK_SCORE_DELETE_INDICES = `${INTERNAL_RISK_SCORE_URL}/indices/delete`;
const RISK_SCORE_CREATE_STORED_SCRIPT = exports.RISK_SCORE_CREATE_STORED_SCRIPT = `${INTERNAL_RISK_SCORE_URL}/stored_scripts/create`;
const RISK_SCORE_DELETE_STORED_SCRIPT = exports.RISK_SCORE_DELETE_STORED_SCRIPT = `${INTERNAL_RISK_SCORE_URL}/stored_scripts/delete`;
const RISK_SCORE_PREVIEW_URL = exports.RISK_SCORE_PREVIEW_URL = `${INTERNAL_RISK_SCORE_URL}/preview`;