"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreEntity = exports.RiskLevels = exports.RiskEngineStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RiskScoreEntity = exports.RiskScoreEntity = /*#__PURE__*/function (RiskScoreEntity) {
  RiskScoreEntity["host"] = "host";
  RiskScoreEntity["user"] = "user";
  return RiskScoreEntity;
}({});
let RiskEngineStatus = exports.RiskEngineStatus = /*#__PURE__*/function (RiskEngineStatus) {
  RiskEngineStatus["NOT_INSTALLED"] = "NOT_INSTALLED";
  RiskEngineStatus["DISABLED"] = "DISABLED";
  RiskEngineStatus["ENABLED"] = "ENABLED";
  return RiskEngineStatus;
}({});
/**
 * The API response object representing a risk score
 */
let RiskLevels = exports.RiskLevels = /*#__PURE__*/function (RiskLevels) {
  RiskLevels["unknown"] = "Unknown";
  RiskLevels["low"] = "Low";
  RiskLevels["moderate"] = "Moderate";
  RiskLevels["high"] = "High";
  RiskLevels["critical"] = "Critical";
  return RiskLevels;
}({});