"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUploadAction = exports.isGetFileAction = exports.isExecuteAction = exports.isAgentType = exports.isActionType = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isUploadAction = action => {
  return action.command === 'upload';
};
exports.isUploadAction = isUploadAction;
const isExecuteAction = action => {
  return action.command === 'execute';
};
exports.isExecuteAction = isExecuteAction;
const isGetFileAction = action => {
  return action.command === 'get-file';
};

// type guards to ensure only the matching string values are attached to the types filter type
exports.isGetFileAction = isGetFileAction;
const isAgentType = type => _constants.RESPONSE_ACTION_AGENT_TYPE.includes(type);
exports.isAgentType = isAgentType;
const isActionType = type => _constants.RESPONSE_ACTION_TYPE.includes(type);
exports.isActionType = isActionType;