"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isResponseActionSupported = exports.isActionSupportedByAgentType = void 0;
var _utils = require("./utils");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** @private */
const getResponseActionsSupportMap = ({
  agentType,
  actionName,
  actionType,
  privileges
}) => {
  const commandName = _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[actionName];
  const RESPONSE_ACTIONS_SUPPORT_MAP = {
    [actionName]: {
      automated: {
        [agentType]: agentType === 'endpoint' ? (0, _utils.getRbacControl)({
          commandName,
          privileges
        }) : false
      },
      manual: {
        [agentType]: agentType === 'endpoint' ? (0, _utils.getRbacControl)({
          commandName,
          privileges
        }) : actionName === 'isolate' || actionName === 'unisolate'
      }
    }
  };
  return RESPONSE_ACTIONS_SUPPORT_MAP[actionName][actionType][agentType];
};

/**
 * Determine if a given response action is currently supported
 * @param agentType
 * @param actionName
 * @param actionType
 * @param privileges
 */
const isResponseActionSupported = (agentType, actionName, actionType, privileges) => {
  return getResponseActionsSupportMap({
    privileges,
    actionName,
    actionType,
    agentType
  });
};

/** @private */
exports.isResponseActionSupported = isResponseActionSupported;
const RESPONSE_ACTIONS_SUPPORT_MAP = {
  isolate: {
    automated: {
      endpoint: true,
      sentinel_one: false
    },
    manual: {
      endpoint: true,
      sentinel_one: true
    }
  },
  unisolate: {
    automated: {
      endpoint: true,
      sentinel_one: false
    },
    manual: {
      endpoint: true,
      sentinel_one: true
    }
  },
  upload: {
    automated: {
      endpoint: true,
      sentinel_one: false
    },
    manual: {
      endpoint: true,
      sentinel_one: false
    }
  },
  'get-file': {
    automated: {
      endpoint: true,
      sentinel_one: false
    },
    manual: {
      endpoint: true,
      sentinel_one: false
    }
  },
  'kill-process': {
    automated: {
      endpoint: true,
      sentinel_one: false
    },
    manual: {
      endpoint: true,
      sentinel_one: false
    }
  },
  execute: {
    automated: {
      endpoint: true,
      sentinel_one: false
    },
    manual: {
      endpoint: true,
      sentinel_one: false
    }
  },
  'suspend-process': {
    automated: {
      endpoint: true,
      sentinel_one: false
    },
    manual: {
      endpoint: true,
      sentinel_one: false
    }
  },
  'running-processes': {
    automated: {
      endpoint: true,
      sentinel_one: false
    },
    manual: {
      endpoint: true,
      sentinel_one: false
    }
  }
};

// FIXME:PT reemove once this module is refactored.
const isActionSupportedByAgentType = (agentType, actionName, actionType) => {
  return RESPONSE_ACTIONS_SUPPORT_MAP[actionName][actionType][agentType];
};
exports.isActionSupportedByAgentType = isActionSupportedByAgentType;