"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESPONSE_CONSOLE_COMMAND_TO_API_COMMAND_MAP = exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_REQUIRED_AUTHZ = exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_RBAC_FEATURE_CONTROL = exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_ENDPOINT_CAPABILITY = exports.RESPONSE_ACTION_TYPE = exports.RESPONSE_ACTION_STATUS = exports.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP = exports.RESPONSE_ACTION_API_COMMANDS_NAMES = exports.RESPONSE_ACTION_AGENT_TYPE = exports.ENDPOINT_CAPABILITIES = exports.ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS = exports.DEFAULT_EXECUTE_ACTION_TIMEOUT = exports.CONSOLE_RESPONSE_ACTION_COMMANDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESPONSE_ACTION_STATUS = exports.RESPONSE_ACTION_STATUS = ['failed', 'pending', 'successful'];
const RESPONSE_ACTION_TYPE = exports.RESPONSE_ACTION_TYPE = ['automated', 'manual'];
const RESPONSE_ACTION_AGENT_TYPE = exports.RESPONSE_ACTION_AGENT_TYPE = ['endpoint', 'sentinel_one'];
/**
 * The Command names that are used in the API payload for the `{ command: '' }` attribute
 */
const RESPONSE_ACTION_API_COMMANDS_NAMES = exports.RESPONSE_ACTION_API_COMMANDS_NAMES = ['isolate', 'unisolate', 'kill-process', 'suspend-process', 'running-processes', 'get-file', 'execute', 'upload'];
const ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS = exports.ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS = ['isolate'
// TODO: TC- Uncomment these when we go GA with automated process actions
// 'kill-process',
// 'suspend-process'
];
/**
 * The list of possible capabilities, reported by the endpoint in the metadata document
 */
const ENDPOINT_CAPABILITIES = exports.ENDPOINT_CAPABILITIES = ['isolation', 'kill_process', 'suspend_process', 'running_processes', 'get_file', 'execute', 'upload_file'];
/**
 * The list of possible console command names that generate a Response Action to be dispatched
 * to the Endpoint. (FYI: not all console commands are response actions)
 */
const CONSOLE_RESPONSE_ACTION_COMMANDS = exports.CONSOLE_RESPONSE_ACTION_COMMANDS = ['isolate', 'release', 'kill-process', 'suspend-process', 'processes', 'get-file', 'execute', 'upload'];
/**
 * maps the console command to the RBAC control (kibana feature control) that is required to access it via console
 */
const RESPONSE_CONSOLE_ACTION_COMMANDS_TO_RBAC_FEATURE_CONTROL = exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_RBAC_FEATURE_CONTROL = Object.freeze({
  isolate: 'writeHostIsolation',
  release: 'writeHostIsolationRelease',
  'kill-process': 'writeProcessOperations',
  'suspend-process': 'writeProcessOperations',
  processes: 'writeProcessOperations',
  'get-file': 'writeFileOperations',
  execute: 'writeExecuteOperations',
  upload: 'writeFileOperations'
});
const RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP = exports.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP = Object.freeze({
  isolate: 'isolate',
  unisolate: 'release',
  execute: 'execute',
  'get-file': 'get-file',
  'running-processes': 'processes',
  'kill-process': 'kill-process',
  'suspend-process': 'suspend-process',
  upload: 'upload'
});
const RESPONSE_CONSOLE_COMMAND_TO_API_COMMAND_MAP = exports.RESPONSE_CONSOLE_COMMAND_TO_API_COMMAND_MAP = Object.freeze({
  isolate: 'isolate',
  release: 'unisolate',
  execute: 'execute',
  'get-file': 'get-file',
  processes: 'running-processes',
  'kill-process': 'kill-process',
  'suspend-process': 'suspend-process',
  upload: 'upload'
});
const RESPONSE_CONSOLE_ACTION_COMMANDS_TO_ENDPOINT_CAPABILITY = exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_ENDPOINT_CAPABILITY = Object.freeze({
  isolate: 'isolation',
  release: 'isolation',
  execute: 'execute',
  'get-file': 'get_file',
  processes: 'running_processes',
  'kill-process': 'kill_process',
  'suspend-process': 'suspend_process',
  upload: 'upload_file'
});

/**
 * The list of console commands mapped to the required EndpointAuthz to access that command
 */
const RESPONSE_CONSOLE_ACTION_COMMANDS_TO_REQUIRED_AUTHZ = exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_REQUIRED_AUTHZ = Object.freeze({
  isolate: 'canIsolateHost',
  release: 'canUnIsolateHost',
  execute: 'canWriteExecuteOperations',
  'get-file': 'canWriteFileOperations',
  upload: 'canWriteFileOperations',
  processes: 'canGetRunningProcesses',
  'kill-process': 'canKillProcess',
  'suspend-process': 'canSuspendProcess'
});

// 4 hrs in seconds
// 4 * 60 * 60
const DEFAULT_EXECUTE_ACTION_TIMEOUT = exports.DEFAULT_EXECUTE_ACTION_TIMEOUT = 14400;