"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalNotes = exports.eventNotes = exports.ImportTimelinesSchemaRt = exports.ImportTimelinesPayloadSchemaRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _api = require("../model/api");
var _utility_types = require("../../../utility_types");
var _pinned_events_route = require("../pinned_events/pinned_events_route");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const eventNotes = exports.eventNotes = (0, _utility_types.unionWithNullType)(rt.array(_api.BareNoteSchema));
const globalNotes = exports.globalNotes = (0, _utility_types.unionWithNullType)(rt.array(_api.BareNoteSchema));
const ImportTimelinesSchemaRt = exports.ImportTimelinesSchemaRt = rt.intersection([_api.SavedTimelineRuntimeType, rt.type({
  savedObjectId: (0, _utility_types.unionWithNullType)(rt.string),
  version: (0, _utility_types.unionWithNullType)(rt.string)
}), rt.type({
  globalNotes,
  eventNotes,
  pinnedEventIds: _pinned_events_route.pinnedEventIds
})]);
const ReadableRt = rt.partial({
  _maxListeners: rt.unknown,
  _readableState: rt.unknown,
  _read: rt.unknown,
  readable: rt.boolean,
  _events: rt.unknown,
  _eventsCount: rt.number,
  _data: rt.unknown,
  _position: rt.number,
  _encoding: rt.string
});
const booleanInString = rt.union([rt.literal('true'), rt.literal('false')]);
const ImportTimelinesPayloadSchemaRt = exports.ImportTimelinesPayloadSchemaRt = rt.intersection([rt.type({
  file: rt.intersection([ReadableRt, rt.type({
    hapi: rt.type({
      filename: rt.string,
      headers: rt.unknown
    })
  })])
}), rt.partial({
  isImmutable: booleanInString
})]);