"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersSchema = exports.UsersFields = void 0;
var _zod = require("zod");
var _factory_query_type = require("../model/factory_query_type");
var _request_paginated_options = require("../model/request_paginated_options");
var _sort = require("../model/sort");
var _timerange = require("../model/timerange");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let UsersFields = exports.UsersFields = /*#__PURE__*/function (UsersFields) {
  UsersFields["name"] = "name";
  UsersFields["domain"] = "domain";
  UsersFields["lastSeen"] = "lastSeen";
  return UsersFields;
}({});
const usersSchema = exports.usersSchema = _request_paginated_options.requestOptionsPaginatedSchema.extend({
  sort: _sort.sort.removeDefault().extend({
    field: _zod.z.enum([UsersFields.name, UsersFields.lastSeen])
  }),
  timerange: _timerange.timerange,
  isNewRiskScoreModuleInstalled: _zod.z.boolean().default(false),
  factoryQueryType: _zod.z.literal(_factory_query_type.UsersQueries.users)
});