"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hostUncommonProcessesSchema = void 0;
var _zod = require("zod");
var _factory_query_type = require("../model/factory_query_type");
var _pagination = require("../model/pagination");
var _request_basic_options = require("../model/request_basic_options");
var _sort = require("../model/sort");
var _timerange = require("../model/timerange");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hostUncommonProcessesSchema = exports.hostUncommonProcessesSchema = _request_basic_options.requestBasicOptionsSchema.extend({
  sort: _sort.sort,
  pagination: _pagination.pagination,
  timerange: _timerange.timerange,
  factoryQueryType: _zod.z.literal(_factory_query_type.HostsQueries.uncommonProcesses)
});