"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IdFieldEnum = exports.IdField = exports.CreateAssetCriticalityRecord = exports.AssetCriticalityRecordIdParts = exports.AssetCriticalityRecord = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Asset Criticality Common Schema
 *   version: 1.0.0
 */

const IdField = exports.IdField = _zod.z.enum(['host.name', 'user.name']);
const IdFieldEnum = exports.IdFieldEnum = IdField.enum;
const AssetCriticalityRecordIdParts = exports.AssetCriticalityRecordIdParts = _zod.z.object({
  /**
   * The ID value of the asset.
   */
  id_value: _zod.z.string(),
  /**
   * The field representing the ID.
   */
  id_field: IdField
});
const CreateAssetCriticalityRecord = exports.CreateAssetCriticalityRecord = AssetCriticalityRecordIdParts.merge(_zod.z.object({
  /**
   * The criticality level of the asset.
   */
  criticality_level: _zod.z.enum(['low_impact', 'medium_impact', 'high_impact', 'extreme_impact'])
}));
const AssetCriticalityRecord = exports.AssetCriticalityRecord = CreateAssetCriticalityRecord.merge(_zod.z.object({
  /**
   * The time the record was created or updated.
   */
  '@timestamp': _zod.z.string().datetime()
}));