"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithOutputs = exports.UserIds = exports.Types = exports.TypeEnum = exports.Type = exports.Timeout = exports.SuccessResponse = exports.Statuses = exports.StatusEnum = exports.Status = exports.StartDate = exports.ProcessActionSchemas = exports.Parameters = exports.PageSize = exports.Page = exports.IdOrUndefined = exports.Id = exports.EndpointIds = exports.EndDate = exports.Comment = exports.Commands = exports.CommandEnum = exports.Command = exports.CaseIds = exports.BaseActionSchema = exports.AgentIds = exports.AgentId = void 0;
var _zod = require("zod");
var _alert = require("../../../model/alert.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Endpoint Attributes
 *   version: 2023-10-31
 */

const Id = exports.Id = _zod.z.string();
const IdOrUndefined = exports.IdOrUndefined = Id.nullable();

/**
 * Page number
 */

const Page = exports.Page = _zod.z.number().int().min(1).default(1);

/**
 * Number of items per page
 */

const PageSize = exports.PageSize = _zod.z.number().int().min(1).max(100).default(10);

/**
 * Start date
 */

const StartDate = exports.StartDate = _zod.z.string();

/**
 * End date
 */

const EndDate = exports.EndDate = _zod.z.string();

/**
 * Agent ID
 */

const AgentId = exports.AgentId = _zod.z.string();
const AgentIds = exports.AgentIds = _zod.z.union([_zod.z.array(_zod.z.string().min(1)).min(1).max(50), _zod.z.string().min(1)]);

/**
 * The command to be executed (cannot be an empty string)
 */

const Command = exports.Command = _zod.z.enum(['isolate', 'unisolate', 'kill-process', 'suspend-process', 'running-processes', 'get-file', 'execute', 'upload']);
const CommandEnum = exports.CommandEnum = Command.enum;
const Commands = exports.Commands = _zod.z.array(Command);

/**
 * The maximum timeout value in milliseconds (optional)
 */

const Timeout = exports.Timeout = _zod.z.number().int().min(1);
const Status = exports.Status = _zod.z.enum(['failed', 'pending', 'successful']);
const StatusEnum = exports.StatusEnum = Status.enum;
const Statuses = exports.Statuses = _zod.z.array(Status);

/**
 * User IDs
 */

const UserIds = exports.UserIds = _zod.z.union([_zod.z.array(_zod.z.string().min(1)).min(1), _zod.z.string().min(1)]);

/**
 * With Outputs
 */

const WithOutputs = exports.WithOutputs = _zod.z.union([_zod.z.array(_zod.z.string().min(1)).min(1), _zod.z.string().min(1)]);
const Type = exports.Type = _zod.z.enum(['automated', 'manual']);
const TypeEnum = exports.TypeEnum = Type.enum;
const Types = exports.Types = _zod.z.array(Type);

/**
 * List of endpoint IDs (cannot contain empty strings)
 */

const EndpointIds = exports.EndpointIds = _zod.z.array(_zod.z.string().min(1)).min(1);

/**
 * Case IDs to be updated (cannot contain empty strings)
 */

const CaseIds = exports.CaseIds = _zod.z.array(_zod.z.string().min(1)).min(1);

/**
 * Optional comment
 */

const Comment = exports.Comment = _zod.z.string();

/**
 * Optional parameters object
 */

const Parameters = exports.Parameters = _zod.z.object({});
const BaseActionSchema = exports.BaseActionSchema = _zod.z.object({
  endpoint_ids: EndpointIds.optional(),
  alert_ids: _alert.AlertIds.optional(),
  case_ids: CaseIds.optional(),
  comment: Comment.optional(),
  parameters: Parameters.optional()
});
const ProcessActionSchemas = exports.ProcessActionSchemas = BaseActionSchema.merge(_zod.z.object({
  parameters: _zod.z.union([_zod.z.object({
    pid: _zod.z.number().int().min(1).optional()
  }), _zod.z.object({
    entity_id: _zod.z.string().min(1).optional()
  })])
}));
const SuccessResponse = exports.SuccessResponse = _zod.z.object({});