"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListRequestQuery = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: List Metadata Schema
 *   version: 2023-10-31
 */

const ListRequestQuery = exports.ListRequestQuery = _zod.z.object({
  /**
   * Page number
   */
  page: _zod.z.number().int().min(0).optional().default(0),
  /**
   * Number of items per page
   */
  pageSize: _zod.z.number().int().min(1).max(10000).optional().default(10),
  kuery: _zod.z.string().nullable().optional(),
  sortField: _zod.z.enum(['enrolled_at', 'metadata.host.hostname', 'host_status', 'metadata.Endpoint.policy.applied.name', 'metadata.Endpoint.policy.applied.status', 'metadata.host.os.name', 'metadata.host.ip', 'metadata.agent.version', 'last_checkin']).optional(),
  sortDirection: _zod.z.enum(['asc', 'desc']).nullable().optional(),
  hostStatuses: _zod.z.array(_zod.z.enum(['healthy', 'offline', 'updating', 'inactive', 'unenrolled']))
});