"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logLevelToNumber = exports.logLevelFromNumber = exports.logLevelFromExecutionStatus = exports.LOG_LEVELS = void 0;
var _utility_types = require("../../../../utility_types");
var _execution_status = require("./execution_status.gen");
var _execution_event = require("./execution_event.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * An array of supported log levels.
 */
const LOG_LEVELS = exports.LOG_LEVELS = _execution_event.LogLevel.options;
const logLevelToNumber = level => {
  if (!level) {
    return 0;
  }
  switch (level) {
    case _execution_event.LogLevelEnum.trace:
      return 0;
    case _execution_event.LogLevelEnum.debug:
      return 10;
    case _execution_event.LogLevelEnum.info:
      return 20;
    case _execution_event.LogLevelEnum.warn:
      return 30;
    case _execution_event.LogLevelEnum.error:
      return 40;
    default:
      (0, _utility_types.assertUnreachable)(level);
      return 0;
  }
};
exports.logLevelToNumber = logLevelToNumber;
const logLevelFromNumber = num => {
  if (num === null || num === undefined || num < 10) {
    return _execution_event.LogLevelEnum.trace;
  }
  if (num < 20) {
    return _execution_event.LogLevelEnum.debug;
  }
  if (num < 30) {
    return _execution_event.LogLevelEnum.info;
  }
  if (num < 40) {
    return _execution_event.LogLevelEnum.warn;
  }
  return _execution_event.LogLevelEnum.error;
};
exports.logLevelFromNumber = logLevelFromNumber;
const logLevelFromExecutionStatus = status => {
  switch (status) {
    case _execution_status.RuleExecutionStatusEnum['going to run']:
    case _execution_status.RuleExecutionStatusEnum.running:
    case _execution_status.RuleExecutionStatusEnum.succeeded:
      return _execution_event.LogLevelEnum.info;
    case _execution_status.RuleExecutionStatusEnum['partial failure']:
      return _execution_event.LogLevelEnum.warn;
    case _execution_status.RuleExecutionStatusEnum.failed:
      return _execution_event.LogLevelEnum.error;
    default:
      (0, _utility_types.assertUnreachable)(status);
      return _execution_event.LogLevelEnum.trace;
  }
};
exports.logLevelFromExecutionStatus = logLevelFromExecutionStatus;