"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortFieldOfRuleExecutionResultEnum = exports.SortFieldOfRuleExecutionResult = exports.RuleExecutionResult = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Execution Result Schema
 *   version: not applicable
 */

/**
 * Rule execution result is an aggregate that groups plain rule execution events by execution UUID. It contains such information as execution UUID, date, status and metrics.
 */

const RuleExecutionResult = exports.RuleExecutionResult = _zod.z.object({
  execution_uuid: _zod.z.string(),
  timestamp: _zod.z.string().datetime(),
  duration_ms: _zod.z.number().int(),
  status: _zod.z.string(),
  message: _zod.z.string(),
  num_active_alerts: _zod.z.number().int(),
  num_new_alerts: _zod.z.number().int(),
  num_recovered_alerts: _zod.z.number().int(),
  num_triggered_actions: _zod.z.number().int(),
  num_succeeded_actions: _zod.z.number().int(),
  num_errored_actions: _zod.z.number().int(),
  total_search_duration_ms: _zod.z.number().int(),
  es_search_duration_ms: _zod.z.number().int(),
  schedule_delay_ms: _zod.z.number().int(),
  timed_out: _zod.z.boolean(),
  indexing_duration_ms: _zod.z.number().int(),
  search_duration_ms: _zod.z.number().int(),
  gap_duration_s: _zod.z.number().int(),
  security_status: _zod.z.string(),
  security_message: _zod.z.string()
});

/**
 * We support sorting rule execution results by these fields.
 */

const SortFieldOfRuleExecutionResult = exports.SortFieldOfRuleExecutionResult = _zod.z.enum(['timestamp', 'duration_ms', 'gap_duration_s', 'indexing_duration_ms', 'search_duration_ms', 'schedule_delay_ms']);
const SortFieldOfRuleExecutionResultEnum = exports.SortFieldOfRuleExecutionResultEnum = SortFieldOfRuleExecutionResult.enum;