"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindRulesSortFieldEnum = exports.FindRulesSortField = exports.FindRulesResponse = exports.FindRulesRequestQuery = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _sorting = require("../../model/sorting.gen");
var _rule_schemas = require("../../model/rule_schema/rule_schemas.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find Rules API endpoint
 *   version: 2023-10-31
 */

const FindRulesSortField = exports.FindRulesSortField = _zod.z.enum(['created_at', 'createdAt', 'enabled', 'execution_summary.last_execution.date', 'execution_summary.last_execution.metrics.execution_gap_duration_s', 'execution_summary.last_execution.metrics.total_indexing_duration_ms', 'execution_summary.last_execution.metrics.total_search_duration_ms', 'execution_summary.last_execution.status', 'name', 'risk_score', 'riskScore', 'severity', 'updated_at', 'updatedAt']);
const FindRulesSortFieldEnum = exports.FindRulesSortFieldEnum = FindRulesSortField.enum;
const FindRulesRequestQuery = exports.FindRulesRequestQuery = _zod.z.object({
  fields: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * Search query
   */
  filter: _zod.z.string().optional(),
  /**
   * Field to sort by
   */
  sort_field: FindRulesSortField.optional(),
  /**
   * Sort order
   */
  sort_order: _sorting.SortOrder.optional(),
  /**
   * Page number
   */
  page: _zod.z.coerce.number().int().min(1).optional().default(1),
  /**
   * Rules per page
   */
  per_page: _zod.z.coerce.number().int().min(0).optional().default(20)
});
const FindRulesResponse = exports.FindRulesResponse = _zod.z.object({
  page: _zod.z.number().int(),
  perPage: _zod.z.number().int(),
  total: _zod.z.number().int(),
  data: _zod.z.array(_rule_schemas.RuleResponse)
});