"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportRulesRequestQuery = exports.ExportRulesRequestBody = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common_attributes = require("../../model/rule_schema/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Export Rules API endpoint
 *   version: 2023-10-31
 */

const ExportRulesRequestQuery = exports.ExportRulesRequestQuery = _zod.z.object({
  /**
   * Determines whether a summary of the exported rules is returned.
   */
  exclude_export_details: _zodHelpers.BooleanFromString.optional().default(false),
  /**
   * File name for saving the exported rules.
   */
  file_name: _zod.z.string().optional().default('export.ndjson')
});
const ExportRulesRequestBody = exports.ExportRulesRequestBody = _zod.z.object({
  /**
   * Array of `rule_id` fields. Exports all rules when unspecified.
   */
  objects: _zod.z.array(_zod.z.object({
    rule_id: _common_attributes.RuleSignatureId
  }))
}).nullable();