"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampOverrideFallbackDisabled = exports.TimestampOverride = exports.TimelineTemplateTitle = exports.TimelineTemplateId = exports.ThreatTechnique = exports.ThreatTactic = exports.ThreatSubtechnique = exports.ThreatArray = exports.Threat = exports.SeverityMapping = exports.SeverityEnum = exports.Severity = exports.SetupGuide = exports.SavedQueryId = exports.SavedObjectResolveOutcomeEnum = exports.SavedObjectResolveOutcome = exports.SavedObjectResolveAliasTargetId = exports.SavedObjectResolveAliasPurposeEnum = exports.SavedObjectResolveAliasPurpose = exports.RuleVersion = exports.RuleTagArray = exports.RuleSignatureId = exports.RuleReferenceArray = exports.RuleQuery = exports.RuleObjectId = exports.RuleNameOverride = exports.RuleName = exports.RuleMetadata = exports.RuleLicense = exports.RuleIntervalTo = exports.RuleIntervalFrom = exports.RuleInterval = exports.RuleFilterArray = exports.RuleFalsePositiveArray = exports.RuleExceptionList = exports.RuleDescription = exports.RuleAuthorArray = exports.RuleActionThrottle = exports.RuleActionParams = exports.RuleActionNotifyWhenEnum = exports.RuleActionNotifyWhen = exports.RuleActionId = exports.RuleActionGroup = exports.RuleActionFrequency = exports.RuleActionAlertsFilter = exports.RuleAction = exports.RiskScoreMapping = exports.RiskScore = exports.RequiredFieldArray = exports.RequiredField = exports.RelatedIntegrationArray = exports.RelatedIntegration = exports.QueryLanguageEnum = exports.QueryLanguage = exports.MaxSignals = exports.KqlQueryLanguageEnum = exports.KqlQueryLanguage = exports.IsRuleImmutable = exports.IsRuleEnabled = exports.InvestigationGuide = exports.InvestigationFields = exports.IndexPatternArray = exports.ExceptionListTypeEnum = exports.ExceptionListType = exports.DataViewId = exports.BuildingBlockType = exports.AlertsIndexNamespace = exports.AlertsIndex = exports.AlertSuppressionMissingFieldsStrategyEnum = exports.AlertSuppressionMissingFieldsStrategy = exports.AlertSuppressionGroupBy = exports.AlertSuppressionDuration = exports.AlertSuppressionCamel = exports.AlertSuppression = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _primitives = require("../../../model/primitives.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Rule Attributes
 *   version: not applicable
 */

const RuleObjectId = exports.RuleObjectId = _primitives.UUID;

/**
 * Could be any string, not necessarily a UUID
 */

const RuleSignatureId = exports.RuleSignatureId = _zod.z.string();
const RuleName = exports.RuleName = _zod.z.string().min(1);
const RuleDescription = exports.RuleDescription = _zod.z.string().min(1);

/**
 * The rule's version number.
 */

const RuleVersion = exports.RuleVersion = _zod.z.number().int().min(1);
const QueryLanguage = exports.QueryLanguage = _zod.z.enum(['kuery', 'lucene', 'eql', 'esql']);
const QueryLanguageEnum = exports.QueryLanguageEnum = QueryLanguage.enum;
const KqlQueryLanguage = exports.KqlQueryLanguage = _zod.z.enum(['kuery', 'lucene']);
const KqlQueryLanguageEnum = exports.KqlQueryLanguageEnum = KqlQueryLanguage.enum;
const IsRuleImmutable = exports.IsRuleImmutable = _zod.z.boolean();

/**
 * Determines whether the rule is enabled.
 */

const IsRuleEnabled = exports.IsRuleEnabled = _zod.z.boolean();

/**
 * Frequency of rule execution, using a date math range. For example, "1h" means the rule runs every hour. Defaults to 5m (5 minutes).
 */

const RuleInterval = exports.RuleInterval = _zod.z.string();

/**
 * Time from which data is analyzed each time the rule executes, using a date math range. For example, now-4200s means the rule analyzes data from 70 minutes before its start time. Defaults to now-6m (analyzes data from 6 minutes before the start time).
 */

const RuleIntervalFrom = exports.RuleIntervalFrom = _zod.z.string().superRefine(_zodHelpers.isValidDateMath);
const RuleIntervalTo = exports.RuleIntervalTo = _zod.z.string();

/**
 * Risk score (0 to 100)
 */

const RiskScore = exports.RiskScore = _zod.z.number().int().min(0).max(100);

/**
 * Overrides generated alerts' risk_score with a value from the source event
 */

const RiskScoreMapping = exports.RiskScoreMapping = _zod.z.array(_zod.z.object({
  field: _zod.z.string(),
  operator: _zod.z.literal('equals'),
  value: _zod.z.string(),
  risk_score: RiskScore.optional()
}));

/**
 * Severity of the rule
 */

const Severity = exports.Severity = _zod.z.enum(['low', 'medium', 'high', 'critical']);
const SeverityEnum = exports.SeverityEnum = Severity.enum;

/**
 * Overrides generated alerts' severity with values from the source event
 */

const SeverityMapping = exports.SeverityMapping = _zod.z.array(_zod.z.object({
  field: _zod.z.string(),
  operator: _zod.z.literal('equals'),
  severity: Severity,
  value: _zod.z.string()
}));

/**
 * String array containing words and phrases to help categorize, filter, and search rules. Defaults to an empty array.
 */

const RuleTagArray = exports.RuleTagArray = _zod.z.array(_zod.z.string());
const RuleMetadata = exports.RuleMetadata = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * The rule's license.
 */

const RuleLicense = exports.RuleLicense = _zod.z.string();
const RuleAuthorArray = exports.RuleAuthorArray = _zod.z.array(_zod.z.string());
const RuleFalsePositiveArray = exports.RuleFalsePositiveArray = _zod.z.array(_zod.z.string());
const RuleReferenceArray = exports.RuleReferenceArray = _zod.z.array(_zod.z.string());

/**
 * Notes to help investigate alerts produced by the rule.
 */

const InvestigationGuide = exports.InvestigationGuide = _zod.z.string();
const SetupGuide = exports.SetupGuide = _zod.z.string();

/**
 * Determines if the rule acts as a building block. By default, building-block alerts are not displayed in the UI. These rules are used as a foundation for other rules that do generate alerts. Its value must be default.
 */

const BuildingBlockType = exports.BuildingBlockType = _zod.z.string();

/**
 * (deprecated) Has no effect.
 */

const AlertsIndex = exports.AlertsIndex = _zod.z.string();

/**
 * Has no effect.
 */

const AlertsIndexNamespace = exports.AlertsIndexNamespace = _zod.z.string();
const MaxSignals = exports.MaxSignals = _zod.z.number().int().min(1);
const ThreatSubtechnique = exports.ThreatSubtechnique = _zod.z.object({
  /**
   * Subtechnique ID
   */
  id: _zod.z.string(),
  /**
   * Subtechnique name
   */
  name: _zod.z.string(),
  /**
   * Subtechnique reference
   */
  reference: _zod.z.string()
});
const ThreatTechnique = exports.ThreatTechnique = _zod.z.object({
  /**
   * Technique ID
   */
  id: _zod.z.string(),
  /**
   * Technique name
   */
  name: _zod.z.string(),
  /**
   * Technique reference
   */
  reference: _zod.z.string(),
  /**
   * Array containing more specific information on the attack technique
   */
  subtechnique: _zod.z.array(ThreatSubtechnique).optional()
});
const ThreatTactic = exports.ThreatTactic = _zod.z.object({
  /**
   * Tactic ID
   */
  id: _zod.z.string(),
  /**
   * Tactic name
   */
  name: _zod.z.string(),
  /**
   * Tactic reference
   */
  reference: _zod.z.string()
});
const Threat = exports.Threat = _zod.z.object({
  /**
   * Relevant attack framework
   */
  framework: _zod.z.string(),
  tactic: ThreatTactic,
  /**
   * Array containing information on the attack techniques (optional)
   */
  technique: _zod.z.array(ThreatTechnique).optional()
});
const ThreatArray = exports.ThreatArray = _zod.z.array(Threat);
const IndexPatternArray = exports.IndexPatternArray = _zod.z.array(_zod.z.string());
const DataViewId = exports.DataViewId = _zod.z.string();
const SavedQueryId = exports.SavedQueryId = _zod.z.string();
const RuleQuery = exports.RuleQuery = _zod.z.string();
const RuleFilterArray = exports.RuleFilterArray = _zod.z.array(_zod.z.unknown());

/**
 * Sets the source field for the alert's signal.rule.name value
 */

const RuleNameOverride = exports.RuleNameOverride = _zod.z.string();

/**
 * Sets the time field used to query indices
 */

const TimestampOverride = exports.TimestampOverride = _zod.z.string();

/**
 * Disables the fallback to the event's @timestamp field
 */

const TimestampOverrideFallbackDisabled = exports.TimestampOverrideFallbackDisabled = _zod.z.boolean();
const RequiredField = exports.RequiredField = _zod.z.object({
  name: _primitives.NonEmptyString,
  type: _primitives.NonEmptyString,
  ecs: _zod.z.boolean()
});
const RequiredFieldArray = exports.RequiredFieldArray = _zod.z.array(RequiredField);

/**
 * Timeline template ID
 */

const TimelineTemplateId = exports.TimelineTemplateId = _zod.z.string();

/**
 * Timeline template title
 */

const TimelineTemplateTitle = exports.TimelineTemplateTitle = _zod.z.string();
const SavedObjectResolveOutcome = exports.SavedObjectResolveOutcome = _zod.z.enum(['exactMatch', 'aliasMatch', 'conflict']);
const SavedObjectResolveOutcomeEnum = exports.SavedObjectResolveOutcomeEnum = SavedObjectResolveOutcome.enum;
const SavedObjectResolveAliasTargetId = exports.SavedObjectResolveAliasTargetId = _zod.z.string();
const SavedObjectResolveAliasPurpose = exports.SavedObjectResolveAliasPurpose = _zod.z.enum(['savedObjectConversion', 'savedObjectImport']);
const SavedObjectResolveAliasPurposeEnum = exports.SavedObjectResolveAliasPurposeEnum = SavedObjectResolveAliasPurpose.enum;
const RelatedIntegration = exports.RelatedIntegration = _zod.z.object({
  package: _primitives.NonEmptyString,
  version: _primitives.NonEmptyString,
  integration: _primitives.NonEmptyString.optional()
});
const RelatedIntegrationArray = exports.RelatedIntegrationArray = _zod.z.array(RelatedIntegration);
const InvestigationFields = exports.InvestigationFields = _zod.z.object({
  field_names: _zod.z.array(_primitives.NonEmptyString).min(1)
});

/**
 * Defines the interval on which a rule's actions are executed.
 */

const RuleActionThrottle = exports.RuleActionThrottle = _zod.z.union([_zod.z.enum(['no_actions', 'rule']), _zod.z.string().regex(/^[1-9]\d*[smhd]$/)]);

/**
 * The condition for throttling the notification: `onActionGroupChange`, `onActiveAlert`,  or `onThrottleInterval`
 */

const RuleActionNotifyWhen = exports.RuleActionNotifyWhen = _zod.z.enum(['onActiveAlert', 'onThrottleInterval', 'onActionGroupChange']);
const RuleActionNotifyWhenEnum = exports.RuleActionNotifyWhenEnum = RuleActionNotifyWhen.enum;

/**
 * The action frequency defines when the action runs (for example, only on rule execution or at specific time intervals).
 */

const RuleActionFrequency = exports.RuleActionFrequency = _zod.z.object({
  /**
   * Action summary indicates whether we will send a summary notification about all the generate alerts or notification per individual alert
   */
  summary: _zod.z.boolean(),
  notifyWhen: RuleActionNotifyWhen,
  throttle: RuleActionThrottle.nullable()
});
const RuleActionAlertsFilter = exports.RuleActionAlertsFilter = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Object containing the allowed connector fields, which varies according to the connector type.
 */

const RuleActionParams = exports.RuleActionParams = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Optionally groups actions by use cases. Use `default` for alert notifications.
 */

const RuleActionGroup = exports.RuleActionGroup = _zod.z.string();

/**
 * The connector ID.
 */

const RuleActionId = exports.RuleActionId = _zod.z.string();
const RuleAction = exports.RuleAction = _zod.z.object({
  /**
   * The action type used for sending notifications.
   */
  action_type_id: _zod.z.string(),
  group: RuleActionGroup,
  id: RuleActionId,
  params: RuleActionParams,
  uuid: _primitives.NonEmptyString.optional(),
  alerts_filter: RuleActionAlertsFilter.optional(),
  frequency: RuleActionFrequency.optional()
});

/**
 * The exception type
 */

const ExceptionListType = exports.ExceptionListType = _zod.z.enum(['detection', 'rule_default', 'endpoint', 'endpoint_trusted_apps', 'endpoint_events', 'endpoint_host_isolation_exceptions', 'endpoint_blocklists']);
const ExceptionListTypeEnum = exports.ExceptionListTypeEnum = ExceptionListType.enum;
const RuleExceptionList = exports.RuleExceptionList = _zod.z.object({
  /**
   * ID of the exception container
   */
  id: _primitives.NonEmptyString,
  /**
   * List ID of the exception container
   */
  list_id: _primitives.NonEmptyString,
  type: ExceptionListType,
  /**
   * Determines the exceptions validity in rule's Kibana space
   */
  namespace_type: _zod.z.enum(['agnostic', 'single'])
});
const AlertSuppressionDuration = exports.AlertSuppressionDuration = _zod.z.object({
  value: _zod.z.number().int().min(1),
  unit: _zod.z.enum(['s', 'm', 'h'])
});

/**
  * Describes how alerts will be generated for documents with missing suppress by fields:
doNotSuppress - per each document a separate alert will be created
suppress - only alert will be created per suppress by bucket
  */

const AlertSuppressionMissingFieldsStrategy = exports.AlertSuppressionMissingFieldsStrategy = _zod.z.enum(['doNotSuppress', 'suppress']);
const AlertSuppressionMissingFieldsStrategyEnum = exports.AlertSuppressionMissingFieldsStrategyEnum = AlertSuppressionMissingFieldsStrategy.enum;
const AlertSuppressionGroupBy = exports.AlertSuppressionGroupBy = _zod.z.array(_zod.z.string()).min(1).max(3);
const AlertSuppression = exports.AlertSuppression = _zod.z.object({
  group_by: AlertSuppressionGroupBy,
  duration: AlertSuppressionDuration.optional(),
  missing_fields_strategy: AlertSuppressionMissingFieldsStrategy.optional()
});
const AlertSuppressionCamel = exports.AlertSuppressionCamel = _zod.z.object({
  groupBy: AlertSuppressionGroupBy,
  duration: AlertSuppressionDuration.optional(),
  missingFieldsStrategy: AlertSuppressionMissingFieldsStrategy.optional()
});