"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetAlertAssigneesRequestBody = exports.AlertAssignees = void 0;
var _zod = require("zod");
var _alert = require("../../model/alert.gen");
var _primitives = require("../../model/primitives.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Assign alerts API endpoint
 *   version: 2023-10-31
 */

const AlertAssignees = exports.AlertAssignees = _zod.z.object({
  /**
   * A list of users ids to assign.
   */
  add: _zod.z.array(_primitives.NonEmptyString),
  /**
   * A list of users ids to unassign.
   */
  remove: _zod.z.array(_primitives.NonEmptyString)
});
const SetAlertAssigneesRequestBody = exports.SetAlertAssigneesRequestBody = _zod.z.object({
  /**
   * Details about the assignees to assign and unassign.
   */
  assignees: AlertAssignees,
  /**
   * List of alerts ids to assign and unassign passed assignees.
   */
  ids: _alert.AlertIds
});