"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySubFeatureId = exports.ProductFeatureSecurityKey = exports.ProductFeatureKey = exports.ProductFeatureCasesKey = exports.ProductFeatureAssistantKey = exports.CasesSubFeatureId = exports.AssistantSubFeatureId = exports.ALL_PRODUCT_FEATURE_KEYS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ProductFeatureSecurityKey = exports.ProductFeatureSecurityKey = /*#__PURE__*/function (ProductFeatureSecurityKey) {
  ProductFeatureSecurityKey["advancedInsights"] = "advanced_insights";
  ProductFeatureSecurityKey["investigationGuide"] = "investigation_guide";
  ProductFeatureSecurityKey["endpointHostManagement"] = "endpoint_host_management";
  ProductFeatureSecurityKey["endpointPolicyManagement"] = "endpoint_policy_management";
  ProductFeatureSecurityKey["endpointPolicyProtections"] = "endpoint_policy_protections";
  ProductFeatureSecurityKey["endpointArtifactManagement"] = "endpoint_artifact_management";
  ProductFeatureSecurityKey["endpointResponseActions"] = "endpoint_response_actions";
  ProductFeatureSecurityKey["threatIntelligence"] = "threat-intelligence";
  ProductFeatureSecurityKey["osqueryAutomatedResponseActions"] = "osquery_automated_response_actions";
  ProductFeatureSecurityKey["endpointProtectionUpdates"] = "endpoint_protection_updates";
  ProductFeatureSecurityKey["endpointAgentTamperProtection"] = "endpoint_agent_tamper_protection";
  ProductFeatureSecurityKey["endpointExceptions"] = "endpointExceptions";
  ProductFeatureSecurityKey["externalRuleActions"] = "external_rule_actions";
  return ProductFeatureSecurityKey;
}({});
let ProductFeatureCasesKey = exports.ProductFeatureCasesKey = /*#__PURE__*/function (ProductFeatureCasesKey) {
  ProductFeatureCasesKey["casesConnectors"] = "cases_connectors";
  return ProductFeatureCasesKey;
}({});
let ProductFeatureAssistantKey = exports.ProductFeatureAssistantKey = /*#__PURE__*/function (ProductFeatureAssistantKey) {
  ProductFeatureAssistantKey["assistant"] = "assistant";
  return ProductFeatureAssistantKey;
}({}); // Merges the two enums.
const ProductFeatureKey = exports.ProductFeatureKey = {
  ...ProductFeatureSecurityKey,
  ...ProductFeatureCasesKey,
  ...ProductFeatureAssistantKey
};
// We need to merge the value and the type and export both to replicate how enum works.

const ALL_PRODUCT_FEATURE_KEYS = exports.ALL_PRODUCT_FEATURE_KEYS = Object.freeze(Object.values(ProductFeatureKey));

/** Sub-features IDs for Security */
let SecuritySubFeatureId = exports.SecuritySubFeatureId = /*#__PURE__*/function (SecuritySubFeatureId) {
  SecuritySubFeatureId["endpointList"] = "endpointListSubFeature";
  SecuritySubFeatureId["endpointExceptions"] = "endpointExceptionsSubFeature";
  SecuritySubFeatureId["trustedApplications"] = "trustedApplicationsSubFeature";
  SecuritySubFeatureId["hostIsolationExceptions"] = "hostIsolationExceptionsSubFeature";
  SecuritySubFeatureId["blocklist"] = "blocklistSubFeature";
  SecuritySubFeatureId["eventFilters"] = "eventFiltersSubFeature";
  SecuritySubFeatureId["policyManagement"] = "policyManagementSubFeature";
  SecuritySubFeatureId["responseActionsHistory"] = "responseActionsHistorySubFeature";
  SecuritySubFeatureId["hostIsolation"] = "hostIsolationSubFeature";
  SecuritySubFeatureId["processOperations"] = "processOperationsSubFeature";
  SecuritySubFeatureId["fileOperations"] = "fileOperationsSubFeature";
  SecuritySubFeatureId["executeAction"] = "executeActionSubFeature";
  return SecuritySubFeatureId;
}({});
/** Sub-features IDs for Cases */
let CasesSubFeatureId = exports.CasesSubFeatureId = /*#__PURE__*/function (CasesSubFeatureId) {
  CasesSubFeatureId["deleteCases"] = "deleteCasesSubFeature";
  CasesSubFeatureId["casesSettings"] = "casesSettingsSubFeature";
  return CasesSubFeatureId;
}({});
/** Sub-features IDs for Security Assistant */
let AssistantSubFeatureId = exports.AssistantSubFeatureId = /*#__PURE__*/function (AssistantSubFeatureId) {
  AssistantSubFeatureId["updateAnonymization"] = "updateAnonymizationSubFeature";
  return AssistantSubFeatureId;
}({});