"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineUpdateApiKeyRoutes = defineUpdateApiKeyRoutes;
var _configSchema = require("@kbn/config-schema");
var _securityPluginTypesServer = require("@kbn/security-plugin-types-server");
var _api_keys = require("../../authentication/api_keys/api_keys");
var _errors = require("../../errors");
var _licensed_route_handler = require("../licensed_route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Response of Kibana Update API key endpoint.
 */

/**
 * Request body of Kibana Update API key endpoint.
 */

const updateRestApiKeySchema = _securityPluginTypesServer.restApiKeySchema.extends({
  name: null,
  id: _configSchema.schema.string()
});
const updateCrossClusterApiKeySchema = _securityPluginTypesServer.crossClusterApiKeySchema.extends({
  name: null,
  id: _configSchema.schema.string()
});
const getRestApiKeyWithKibanaPrivilegesSchema = getBasePrivilegeNames => _securityPluginTypesServer.restApiKeySchema.extends({
  role_descriptors: null,
  name: null,
  id: _configSchema.schema.string(),
  kibana_role_descriptors: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    elasticsearch: _securityPluginTypesServer.elasticsearchRoleSchema.extends({}, {
      unknowns: 'allow'
    }),
    kibana: (0, _securityPluginTypesServer.getKibanaRoleSchema)(getBasePrivilegeNames)
  }))
});
function defineUpdateApiKeyRoutes({
  router,
  authz,
  getAuthenticationService
}) {
  const bodySchemaWithKibanaPrivileges = getRestApiKeyWithKibanaPrivilegesSchema(() => {
    const privileges = authz.privileges.get();
    return {
      global: Object.keys(privileges.global),
      space: Object.keys(privileges.space)
    };
  });
  router.put({
    path: '/internal/security/api_key',
    validate: {
      body: _configSchema.schema.oneOf([updateRestApiKeySchema, updateCrossClusterApiKeySchema, bodySchemaWithKibanaPrivileges])
    },
    options: {
      access: 'internal'
    }
  }, (0, _licensed_route_handler.createLicensedRouteHandler)(async (context, request, response) => {
    try {
      const result = await getAuthenticationService().apiKeys.update(request, request.body);
      if (result === null) {
        return response.badRequest({
          body: {
            message: `API Keys are not available`
          }
        });
      }
      return response.ok({
        body: result
      });
    } catch (error) {
      if (error instanceof _api_keys.UpdateApiKeyValidationError) {
        return response.badRequest({
          body: {
            message: error.message
          }
        });
      }
      return response.customError((0, _errors.wrapIntoCustomErrorResponse)(error));
    }
  }));
}