"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineApiKeysRoutes = defineApiKeysRoutes;
var _create = require("./create");
var _enabled = require("./enabled");
var _get = require("./get");
var _has_active = require("./has_active");
var _invalidate = require("./invalidate");
var _update = require("./update");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineApiKeysRoutes(params) {
  (0, _enabled.defineEnabledApiKeysRoutes)(params);
  (0, _get.defineGetApiKeysRoutes)(params);
  (0, _has_active.defineHasApiKeysRoutes)(params);
  (0, _create.defineCreateApiKeyRoutes)(params);
  (0, _update.defineUpdateApiKeyRoutes)(params);
  (0, _invalidate.defineInvalidateApiKeysRoutes)(params);
}