"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsEuiTableFormatting = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Notes to future engineer:
 * We created this component because as this time EUI actions table where not allowing to pass
 * props href on an action. In our case, we want our actions to work with href
 * and onClick. Then the problem is that the design did not match with EUI example, therefore
 * we are doing some css magic to only have icon showing up when user is hovering a row
 */
const ActionsEuiTableFormatting = exports.ActionsEuiTableFormatting = /*#__PURE__*/_react2.default.memo(({
  children
}) => /*#__PURE__*/_react2.default.createElement("div", {
  css: (0, _react.css)`
        .euiTableRowCell--hasActions .euiButtonEmpty {
          padding: 0;
          .euiButtonEmpty__text {
            display: none;
          }
        }
      `
}, children));