"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceColumnHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _privilege_utils = require("../../../privilege_utils");
var _spaces_popover_list = require("../../../spaces_popover_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPACES_DISPLAY_COUNT = 4;
const SpaceColumnHeader = props => {
  const {
    spacesApiUi
  } = props;
  const isGlobal = (0, _privilege_utils.isGlobalPrivilegeDefinition)(props.entry);
  const entrySpaces = props.entry.spaces.map(spaceId => {
    var _props$spaces$find;
    return (_props$spaces$find = props.spaces.find(s => s.id === spaceId)) !== null && _props$spaces$find !== void 0 ? _props$spaces$find : {
      id: spaceId,
      name: spaceId,
      disabledFeatures: []
    };
  });
  const LazySpaceAvatar = (0, _react.useMemo)(() => spacesApiUi.components.getSpaceAvatar, [spacesApiUi]);
  return /*#__PURE__*/_react.default.createElement("div", null, entrySpaces.slice(0, SPACES_DISPLAY_COUNT).map(space => {
    return /*#__PURE__*/_react.default.createElement("span", {
      key: space.id
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
      size: "s",
      space: space
    }), ' ', isGlobal && /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeMatrix.globalSpaceName",
      defaultMessage: "All Spaces"
    })));
  }), entrySpaces.length > SPACES_DISPLAY_COUNT && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_spaces_popover_list.SpacesPopoverList, {
    spaces: entrySpaces,
    buttonText: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeMatrix.showNMoreSpacesLink', {
      defaultMessage: '+{count} more',
      values: {
        count: entrySpaces.length - SPACES_DISPLAY_COUNT
      }
    }),
    spacesApiUi: spacesApiUi
  })));
};
exports.SpaceColumnHeader = SpaceColumnHeader;