"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchPrivileges = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _cluster_privileges = require("./cluster_privileges");
var _index_privileges = require("./index_privileges");
var _collapsible_panel = require("../../collapsible_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ElasticsearchPrivileges extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getForm", () => {
      const {
        role,
        indicesAPIClient,
        docLinks,
        validator,
        onChange,
        editable,
        indexPatterns,
        remoteClusters,
        license,
        builtinESPrivileges,
        canUseRemoteIndices,
        buildFlavor
      } = this.props;
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.elasticSearchPrivileges.clusterPrivilegesTitle",
          defaultMessage: "Cluster privileges"
        })),
        description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.elasticSearchPrivileges.manageRoleActionsDescription",
          defaultMessage: "Manage the actions this role can perform against your cluster. "
        }), this.learnMore(docLinks.links.security.clusterPrivileges))
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        hasEmptyLabelSpace: true
      }, /*#__PURE__*/_react.default.createElement(_cluster_privileges.ClusterPrivileges, {
        role: this.props.role,
        onChange: this.onClusterPrivilegesChange,
        builtinClusterPrivileges: builtinESPrivileges.cluster,
        editable: editable
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), buildFlavor === 'traditional' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.elasticSearchPrivileges.runAsPrivilegesTitle",
          defaultMessage: "Run As privileges"
        })),
        description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.elasticSearchPrivileges.howToBeSubmittedOnBehalfOfOtherUsersDescription",
          defaultMessage: "Allow requests to be submitted on the behalf of other users. "
        }), this.learnMore(docLinks.links.security.runAsPrivilege))
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.elasticSearchPrivileges.runAsPrivilegesAriaLabel', {
          defaultMessage: 'Run as privileges'
        }),
        placeholder: this.props.editable ? _i18n.i18n.translate('xpack.security.management.editRole.elasticSearchPrivileges.addUserTitle', {
          defaultMessage: 'Add a user…'
        }) : undefined,
        options: this.props.runAsUsers.map(username => ({
          label: username,
          isGroupLabelOption: false
        })),
        selectedOptions: this.props.role.elasticsearch.run_as.map(u => ({
          label: u
        })),
        onCreateOption: this.onCreateRunAsOption,
        onChange: this.onRunAsUserChange,
        isDisabled: !editable
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.indexPrivilegesTitle",
        defaultMessage: "Index privileges"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.controlAccessToClusterDataDescription",
        defaultMessage: "Control access to the data in your cluster. "
      }), this.learnMore(docLinks.links.security.indicesPrivileges))), /*#__PURE__*/_react.default.createElement(_index_privileges.IndexPrivileges, {
        indexType: "indices",
        indexPatterns: indexPatterns,
        role: role,
        indicesAPIClient: indicesAPIClient,
        validator: validator,
        license: license,
        onChange: onChange,
        availableIndexPrivileges: builtinESPrivileges.index,
        editable: editable,
        isDarkMode: this.props.isDarkMode
      }), buildFlavor === 'traditional' && canUseRemoteIndices && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.remoteIndexPrivilegesTitle",
        defaultMessage: "Remote index privileges"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.controlAccessToRemoteClusterDataDescription",
        defaultMessage: "Control access to the data in remote clusters. "
      }), this.learnMore(docLinks.links.security.indicesPrivileges))), /*#__PURE__*/_react.default.createElement(_index_privileges.IndexPrivileges, {
        indexType: "remote_indices",
        remoteClusters: remoteClusters,
        role: role,
        indicesAPIClient: indicesAPIClient,
        validator: validator,
        license: license,
        onChange: onChange,
        availableIndexPrivileges: builtinESPrivileges.index,
        editable: editable,
        isDarkMode: this.props.isDarkMode
      })));
    });
    (0, _defineProperty2.default)(this, "learnMore", href => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      className: "editRole__learnMore",
      href: href,
      target: '_blank'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.elasticSearchPrivileges.learnMoreLinkText",
      defaultMessage: "Learn more"
    })));
    (0, _defineProperty2.default)(this, "addIndexPrivilege", () => {
      const {
        role
      } = this.props;
      const newIndices = [...role.elasticsearch.indices, {
        names: [],
        privileges: [],
        field_security: {
          grant: ['*']
        }
      }];
      this.props.onChange({
        ...this.props.role,
        elasticsearch: {
          ...this.props.role.elasticsearch,
          indices: newIndices
        }
      });
    });
    (0, _defineProperty2.default)(this, "onClusterPrivilegesChange", cluster => {
      const role = {
        ...this.props.role,
        elasticsearch: {
          ...this.props.role.elasticsearch,
          cluster
        }
      };
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "onRunAsUserChange", users => {
      const role = {
        ...this.props.role,
        elasticsearch: {
          ...this.props.role.elasticsearch,
          run_as: users.map(u => u.label)
        }
      };
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "onCreateRunAsOption", option => {
      const newRunAsUsers = this.props.role.elasticsearch.run_as.concat(option);
      const role = {
        ...this.props.role,
        elasticsearch: {
          ...this.props.role.elasticsearch,
          run_as: newRunAsUsers
        }
      };
      this.props.onChange(role);
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
      iconType: 'logoElasticsearch',
      title: 'Elasticsearch'
    }, this.getForm());
  }
}
exports.ElasticsearchPrivileges = ElasticsearchPrivileges;