"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverwrittenSessionPage = OverwrittenSessionPage;
exports.renderOverwrittenSessionPage = renderOverwrittenSessionPage;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _parse_next = require("../../../common/parse_next");
var _components = require("../components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function OverwrittenSessionPage({
  authc,
  basePath
}) {
  const [username, setUsername] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    authc.getCurrentUser().then(user => setUsername(user.username));
  }, [authc]);
  if (username == null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_components.AuthenticationStatePage, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.overwrittenSession.title",
      defaultMessage: "You previously logged in as a different user."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: (0, _parse_next.parseNext)(window.location.href, basePath.serverBasePath)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.overwrittenSession.continueAsUserText",
    defaultMessage: "Continue as {username}",
    values: {
      username
    }
  })));
}
function renderOverwrittenSessionPage(i18nStart, {
  element,
  theme$
}, props) {
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(i18nStart.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(OverwrittenSessionPage, props))), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
}