"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoginPage = void 0;
exports.renderLoginPage = renderLoginPage;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./login_page.scss");
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _components = require("./components");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loginFormMessages = {
  SESSION_EXPIRED: {
    type: _components.LoginFormMessageType.Info,
    content: _i18n.i18n.translate('xpack.security.login.sessionExpiredDescription', {
      defaultMessage: 'Your session has timed out. Please log in again.'
    })
  },
  CONCURRENCY_LIMIT: {
    type: _components.LoginFormMessageType.Info,
    content: _i18n.i18n.translate('xpack.security.login.concurrencyLimitDescription', {
      defaultMessage: 'You have logged in on another device. Please log in again.'
    })
  },
  AUTHENTICATION_ERROR: {
    type: _components.LoginFormMessageType.Info,
    content: _i18n.i18n.translate('xpack.security.login.authenticationErrorDescription', {
      defaultMessage: 'An unexpected authentication error occurred. Please log in again.'
    })
  },
  LOGGED_OUT: {
    type: _components.LoginFormMessageType.Info,
    content: _i18n.i18n.translate('xpack.security.login.loggedOutDescription', {
      defaultMessage: 'You have logged out of Elastic.'
    })
  },
  UNAUTHENTICATED: {
    type: _components.LoginFormMessageType.Danger,
    content: _i18n.i18n.translate('xpack.security.unauthenticated.errorDescription', {
      defaultMessage: 'Try logging in again, and if the problem persists, contact your system administrator.'
    })
  }
};
class LoginPage extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      loginState: null,
      customBranding: {}
    });
    (0, _defineProperty2.default)(this, "customBrandingSubscription", void 0);
    (0, _defineProperty2.default)(this, "getLoginForm", ({
      layout,
      requiresSecureConnection,
      isSecureConnection,
      isCookiesEnabled,
      selector,
      loginHelp
    }) => {
      const isLoginExplicitlyDisabled = selector.providers.length === 0;
      if (isLoginExplicitlyDisabled) {
        return /*#__PURE__*/_react.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.noLoginMethodsAvailableTitle",
            defaultMessage: "Login is disabled."
          }),
          message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.noLoginMethodsAvailableMessage",
            defaultMessage: "Contact your system administrator."
          })
        });
      }
      if (requiresSecureConnection && !isSecureConnection) {
        return /*#__PURE__*/_react.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.requiresSecureConnectionTitle",
            defaultMessage: "A secure connection is required for log in"
          }),
          message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.requiresSecureConnectionMessage",
            defaultMessage: "Contact your system administrator."
          })
        });
      }
      if (!isCookiesEnabled) {
        if (isWindowEmbedded()) {
          return /*#__PURE__*/_react.default.createElement("div", {
            style: {
              maxWidth: '36em',
              margin: 'auto',
              textAlign: 'center'
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            color: "subdued"
          }, /*#__PURE__*/_react.default.createElement("p", null, this.props.sameSiteCookies !== 'None' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.openInNewWindowOrChangeKibanaConfigTitle",
            defaultMessage: "To view this content, open it in a new window or ask your administrator to allow cross-origin cookies."
          }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.openInNewWindowOrChangeBrowserSettingsTitle",
            defaultMessage: "To view this content, open it in a new window or adjust your browser settings to allow third-party cookies."
          }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            href: window.location.href,
            target: "_blank",
            iconType: "popout",
            iconSide: "right",
            fill: true
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.openInNewWindowButton",
            defaultMessage: "Open in new window"
          })));
        }
        return /*#__PURE__*/_react.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.requiresCookiesTitle",
            defaultMessage: "Cookies are required to log in to Elastic"
          }),
          message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.requiresCookiesMessage",
            defaultMessage: "Enable cookies in your browser settings to continue."
          })
        });
      }
      if (layout === 'error-es-unavailable') {
        return /*#__PURE__*/_react.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.esUnavailableTitle",
            defaultMessage: "Cannot connect to the Elasticsearch cluster"
          }),
          message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.esUnavailableMessage",
            defaultMessage: "See the Kibana logs for details and try reloading the page."
          })
        });
      }
      if (layout === 'error-xpack-unavailable') {
        return /*#__PURE__*/_react.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.xpackUnavailableTitle",
            defaultMessage: "Cannot connect to the Elasticsearch cluster currently configured for Kibana."
          }),
          message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.xpackUnavailableMessage",
            defaultMessage: "To use the full set of free features in this distribution of Kibana, please update Elasticsearch to the default distribution."
          })
        });
      }
      if (layout !== 'form') {
        return /*#__PURE__*/_react.default.createElement(_components.DisabledLoginForm, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.unknownLayoutTitle",
            defaultMessage: "Unsupported login form layout."
          }),
          message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.loginPage.unknownLayoutMessage",
            defaultMessage: "See the Kibana logs for details and try reloading the page."
          })
        });
      }
      const {
        searchParams
      } = new URL(window.location.href);
      return /*#__PURE__*/_react.default.createElement(_components.LoginForm, {
        http: this.props.http,
        notifications: this.props.notifications,
        selector: selector,
        message: loginFormMessages[searchParams.get(_constants.LOGOUT_REASON_QUERY_STRING_PARAMETER)],
        loginAssistanceMessage: this.props.loginAssistanceMessage,
        loginHelp: loginHelp,
        authProviderHint: searchParams.get(_constants.AUTH_PROVIDER_HINT_QUERY_STRING_PARAMETER) || undefined
      });
    });
  }
  async componentDidMount() {
    const loadingCount$ = new _rxjs.BehaviorSubject(1);
    this.customBrandingSubscription = this.props.customBranding.customBranding$.subscribe(next => {
      this.setState({
        ...this.state,
        customBranding: next
      });
    });
    this.props.http.addLoadingCountSource(loadingCount$.asObservable());
    try {
      this.setState({
        loginState: await this.props.http.get('/internal/security/login_state')
      });
    } catch (err) {
      this.props.fatalErrors.add(err);
    }
    loadingCount$.next(0);
    loadingCount$.complete();
  }
  componentWillUnmount() {
    var _this$customBrandingS;
    (_this$customBrandingS = this.customBrandingSubscription) === null || _this$customBrandingS === void 0 ? void 0 : _this$customBrandingS.unsubscribe();
  }
  render() {
    var _this$state$customBra;
    const loginState = this.state.loginState;
    if (!loginState) {
      return null;
    }
    const isSecureConnection = !!window.location.protocol.match(/^https/);
    const isCookiesEnabled = window.navigator.cookieEnabled;
    const {
      allowLogin,
      layout,
      requiresSecureConnection
    } = loginState;
    const loginIsSupported = requiresSecureConnection && !isSecureConnection || !isCookiesEnabled ? false : allowLogin && layout === 'form';
    const contentHeaderClasses = (0, _classnames.default)('loginWelcome__content', 'eui-textCenter', {
      ['loginWelcome__contentDisabledForm']: !loginIsSupported
    });
    const contentBodyClasses = (0, _classnames.default)('loginWelcome__content', 'loginWelcome-body', {
      ['loginWelcome__contentDisabledForm']: !loginIsSupported
    });
    const customLogo = (_this$state$customBra = this.state.customBranding) === null || _this$state$customBra === void 0 ? void 0 : _this$state$customBra.logo;
    const logo = customLogo ? /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      src: customLogo,
      size: 40,
      alt: "logo"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElastic",
      size: "xxl"
    });
    // custom logo needs to be centered
    const logoStyle = customLogo ? {
      padding: 0
    } : {};
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "loginWelcome login-form"
    }, /*#__PURE__*/_react.default.createElement("header", {
      className: "loginWelcome__header"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: contentHeaderClasses
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }), /*#__PURE__*/_react.default.createElement("span", {
      className: "loginWelcome__logo",
      style: logoStyle
    }, logo), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      className: "loginWelcome__title",
      "data-test-subj": "loginWelcomeTitle"
    }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.loginPage.welcomeTitle",
      defaultMessage: "Welcome to Elastic"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl"
    }))), /*#__PURE__*/_react.default.createElement("div", {
      className: contentBodyClasses
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, this.getLoginForm({
      ...loginState,
      isSecureConnection,
      isCookiesEnabled
    })))));
  }
}
exports.LoginPage = LoginPage;
function renderLoginPage(i18nStart, {
  element,
  theme$
}, props) {
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(i18nStart.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(LoginPage, props))), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
}
function isWindowEmbedded() {
  try {
    return window.self !== window.top;
  } catch (error) {
    return true;
  }
}