"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loggedOutApp = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const loggedOutApp = exports.loggedOutApp = Object.freeze({
  id: 'security_logged_out',
  create({
    application,
    http,
    getStartServices
  }) {
    http.anonymousPaths.register('/security/logged_out');
    application.register({
      id: this.id,
      title: _i18n.i18n.translate('xpack.security.loggedOutAppTitle', {
        defaultMessage: 'Logged out'
      }),
      chromeless: true,
      appRoute: '/security/logged_out',
      async mount({
        element,
        theme$
      }) {
        const [[coreStart], {
          renderLoggedOutPage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./logged_out_page')))]);
        return renderLoggedOutPage(coreStart.i18n, {
          element,
          theme$
        }, {
          basePath: coreStart.http.basePath,
          customBranding: coreStart.customBranding
        });
      }
    });
  }
});