"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.accountManagementApp = exports.Providers = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _userProfileComponents = require("@kbn/user-profile-components");
var _components = require("../components");
var _breadcrumb = require("../components/breadcrumb");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const accountManagementApp = exports.accountManagementApp = Object.freeze({
  id: 'security_account',
  create({
    application,
    authc,
    getStartServices,
    securityApiClients
  }) {
    application.register({
      id: this.id,
      title: _i18n.i18n.translate('xpack.security.account.breadcrumb', {
        defaultMessage: 'User settings'
      }),
      visibleIn: [],
      appRoute: '/security/account',
      async mount({
        element,
        history
      }) {
        const [[coreStart], {
          AccountManagementPage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./account_management_page')))]);
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(Providers, {
          services: coreStart,
          history: history,
          authc: authc,
          securityApiClients: securityApiClients
        }, /*#__PURE__*/_react.default.createElement(AccountManagementPage, null)), element);
        return () => (0, _reactDom.unmountComponentAtNode)(element);
      }
    });
  }
});
const Providers = ({
  services,
  history,
  authc,
  securityApiClients,
  onChange,
  children
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_components.AuthenticationProvider, {
  authc: authc
}, /*#__PURE__*/_react.default.createElement(_components.SecurityApiClientsProvider, securityApiClients, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
  theme: services.theme
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
  history: history
}, /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
  onChange: onChange
}, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesKibanaProvider, {
  core: services,
  security: {
    userProfiles: securityApiClients.userProfiles
  },
  toMountPoint: _reactKibanaMount.toMountPoint
}, children))))))));
exports.Providers = Providers;