"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Editor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _init_editor = require("./init_editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useUIAceKeyboardMode
} = _shared_imports.ace;
const createEditorShim = aceEditor => {
  return {
    getValue() {
      return aceEditor.getValue();
    },
    focus() {
      aceEditor.focus();
    }
  };
};
const EDITOR_INPUT_ID = 'SearchProfilerTextArea';
const Editor = exports.Editor = /*#__PURE__*/(0, _react.memo)(({
  licenseEnabled,
  initialValue,
  onEditorReady
}) => {
  const containerRef = (0, _react.useRef)(null);
  const editorInstanceRef = (0, _react.useRef)(null);
  const [textArea, setTextArea] = (0, _react.useState)(null);
  useUIAceKeyboardMode(textArea);
  (0, _react.useEffect)(() => {
    const divEl = containerRef.current;
    editorInstanceRef.current = (0, _init_editor.initializeEditor)({
      el: divEl,
      licenseEnabled
    });
    editorInstanceRef.current.setValue(initialValue, 1);
    const textarea = divEl.querySelector('textarea');
    if (textarea) {
      textarea.setAttribute('id', EDITOR_INPUT_ID);
    }
    setTextArea(licenseEnabled ? containerRef.current.querySelector('textarea') : null);
    onEditorReady(createEditorShim(editorInstanceRef.current));
    return () => {
      if (editorInstanceRef.current) {
        editorInstanceRef.current.destroy();
      }
    };
  }, [initialValue, onEditorReady, licenseEnabled]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: EDITOR_INPUT_ID
  }, _i18n.i18n.translate('xpack.searchProfiler.editorElementLabel', {
    defaultMessage: 'Dev Tools Search Profiler editor'
  }))), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "searchProfilerEditor",
    ref: containerRef
  }));
});