/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.searchPlayground_bundle_jsonpfunction=window.searchPlayground_bundle_jsonpfunction||[]).push([[7],{87:function(e,t,n){"use strict";n.r(t),n.d(t,"Toolbar",(function(){return P}));var s=n(5),o=n(1),i=n.n(o),a=n(31),l=n(13),c=n(29),r=n(33),u=n(32),d=n(34);const j=e=>`\n  Instructions:\n  ${e}\n\n  Context:\n  {context}\n\n  Question: {question}\n  Answer:\n  `,p=e=>`\n  <s>[INST]${e}[/INST] </s>\n\n  [INST]\n  Context:\n  {context}\n\n  Question: {question}\n  Answer:\n  [/INST]\n  `,x=e=>`\n  <instructions>${e}</instructions>\n\n  <context>\n  {context}\n  </context>\n\n  <input>{question}</input>\n  `,b=(e,t)=>{const n=`\n  - ${e}\n  ${t.context?"- Answer questions truthfully and factually using only the information presented.":""}\n  - If you don't know the answer, just say that you don't know, don't make up an answer!\n  ${t.citations?"- You must always cite the document where the answer was extracted using inline academic citation style [], using the position.":""}\n  - Use markdown format for code examples.\n  - You are correct, factual, precise, and reliable.\n  `;return{openai:j,mistral:p,anthropic:x}[t.type||"openai"](n)},m=e=>{try{return JSON.stringify(e,null,4).replace(/"{query}"/g,"query").split("\n").map((e=>`    ${e}`)).join("\n").trim()}catch(e){return console.error("Error parsing ES query",e),"{}"}};var O=n(2);const g=(e,t)=>Object(O.jsx)(s.EuiCodeBlock,{language:"py",isCopyable:!0,overflowHeight:"100%"},`## Install the required packages\n## pip install -qU elasticsearch langchain langchain-elasticsearch langchain-openai\n\nfrom langchain_elasticsearch import ElasticsearchRetriever\nfrom langchain_openai import ChatOpenAI\nfrom langchain_core.runnables import RunnablePassthrough\nfrom langchain_core.prompts import ChatPromptTemplate\nfrom langchain_core.output_parsers import StrOutputParser\nfrom langchain_core.prompts import format_document\nfrom langchain.prompts.prompt import PromptTemplate\nimport os\n${t}\n\ndef build_query(query):\n    return ${m(e.elasticsearch_query)}\n\nindex_source_fields = ${(e=>{const t=Object.keys(e).reduce(((t,n)=>(t[n]=e[n][0],t)),{});return JSON.stringify(t,null,4)})(e.source_fields)}\n\nretriever = ElasticsearchRetriever(\n    index_name="${e.indices.join(",")}",\n    body_func=build_query,\n    content_field=index_source_fields,\n    es_client=es_client\n)\n\nmodel = ChatOpenAI(openai_api_key=os.environ["OPENAI_API_KEY"], model_name="gpt-3.5-turbo")\n\nANSWER_PROMPT = ChatPromptTemplate.from_template(\n    """${b(e.prompt,{context:!0,citations:e.citations,type:"openai"})}"""\n)\n\nDEFAULT_DOCUMENT_PROMPT = PromptTemplate.from_template(template="{page_content}")\n\ndef _combine_documents(\n    docs, document_prompt=DEFAULT_DOCUMENT_PROMPT, document_separator="\\n\\n"\n):\n    doc_strings = [format_document(doc, document_prompt) for doc in docs]\n    return document_separator.join(doc_strings)\n\n_context = {\n    "context": retriever | _combine_documents,\n    "question": RunnablePassthrough(),\n}\n\nchain = _context | ANSWER_PROMPT | model | StrOutputParser()\nans = chain.invoke("what is the nasa sales team?")\nprint("---- Answer ----")\nprint(ans)`),y=(e,t)=>Object(O.jsx)(s.EuiCodeBlock,{language:"py",isCopyable:!0,overflowHeight:"100%"},`## Install the required packages\n## pip install -qU elasticsearch openai\n\nimport os\nfrom elasticsearch import Elasticsearch\nfrom openai import OpenAI\n\n${t}\n\nopenai_client = OpenAI(\n    api_key=os.environ["OPENAI_API_KEY"],\n)\n\nindex_source_fields = ${JSON.stringify(e.source_fields,null,4)}\n\ndef get_elasticsearch_results(query):\n    es_query = ${m({...e.elasticsearch_query,size:e.doc_size})}\n\n    result = es_client.search(index="${e.indices.join(",")}", body=es_query)\n    return result["hits"]["hits"]\n\ndef create_openai_prompt(question, results):\n    context = ""\n    for hit in results:\n      source_field = index_source_fields.get(hit["_index"])[0]\n      hit_context = hit["_source"][source_field]\n      context += f"{hit_context}\\n"\n\n    prompt = f"""${b(e.prompt,{context:!0,citations:e.citations,type:"openai"})}"""\n\n    return prompt\n\ndef generate_openai_completion(user_prompt):\n    response = openai_client.chat.completions.create(\n        model="gpt-3.5-turbo",\n        messages=[\n            {"role": "system", "content": "You are an assistant for question-answering tasks."},\n            {"role": "user", "content": user_prompt},\n        ]\n    )\n\n    return response.choices[0].message.content\n\nif __name__ == "__main__":\n    question = "my question"\n    elasticsearch_results = get_elasticsearch_results(question)\n    context_prompt = create_openai_prompt(question, elasticsearch_results)\n    openai_completion = generate_openai_completion(context_prompt)\n    print(openai_completion)\n\n`),h=({onClose:e})=>{const t=Object(u.a)(),[n,i]=Object(o.useState)("py-es-client"),{getValues:c}=Object(a.useFormContext)(),j=c(),{services:{cloud:p,http:x}}=Object(d.a)(),b=(e=>e?`\nes_client = Elasticsearch(\n    "${e.elasticsearchUrl}",\n    api_key=os.environ["ES_API_KEY"]\n)\n      `:'\nes_client = Elasticsearch(\n    "<your-elasticsearch-url>"\n)\n  ')(p),m={"lc-py":g(j,b),"py-es-client":y(j,b)};return Object(o.useEffect)((()=>{null==t||t.load(r.a.viewCodeFlyoutOpened)}),[t]),Object(o.useEffect)((()=>{null==t||t.click(`${r.a.viewCodeLanguageChange}_${n}`)}),[t,n]),Object(O.jsx)(s.EuiFlyout,{ownFocus:!0,onClose:e},Object(O.jsx)(s.EuiFlyoutHeader,{hasBorder:!0},Object(O.jsx)(s.EuiTitle,{size:"m"},Object(O.jsx)("h2",null,Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewCode.flyout.title",defaultMessage:"Application code"}))),Object(O.jsx)(s.EuiSpacer,{size:"s"}),Object(O.jsx)(s.EuiText,{color:"subdued"},Object(O.jsx)("p",null,Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewCode.flyout.subtitle",defaultMessage:"Here's the code used to render this search experience. You can integrate it into your own application, modifying as needed."})))),Object(O.jsx)(s.EuiFlyoutBody,null,Object(O.jsx)(s.EuiFlexGroup,{direction:"column"},Object(O.jsx)(s.EuiFlexItem,{grow:!1},Object(O.jsx)(s.EuiFlexGroup,null,Object(O.jsx)(s.EuiFlexItem,null,Object(O.jsx)(s.EuiSelect,{options:[{value:"py-es-client",text:"Python Elasticsearch Client with OpenAI"},{value:"lc-py",text:"LangChain Python with OpenAI"}],onChange:e=>{i(e.target.value)},value:n})),Object(O.jsx)(s.EuiFlexItem,{grow:!1},Object(O.jsx)(s.EuiButtonEmpty,{color:"primary",iconType:"popout",href:x.basePath.prepend("/app/management/security/api_keys"),"data-test-subj":"viewCodeManageApiKeys",target:"_blank"},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewCode.flyout.apiKeysAction",defaultMessage:"Manage API Keys"}))))),Object(O.jsx)(s.EuiFlexItem,{grow:!1},m[n]))))},f=()=>{const{watch:e}=Object(a.useFormContext)(),[t,n]=Object(o.useState)(!1),r=e(c.b.indices);return Object(O.jsx)(i.a.Fragment,null,t&&Object(O.jsx)(h,{onClose:()=>n(!1)}),Object(O.jsx)(s.EuiButton,{iconType:"editorCodeBlock",color:"primary",fill:!0,onClick:()=>n(!0),disabled:!r||0===(null==r?void 0:r.length)},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewCode.actionButtonLabel",defaultMessage:"View code"})))};var _=n(3),E=n(15);const F=(e=[])=>{const{services:t}=Object(d.a)(),{data:n,isLoading:s}=Object(E.useQuery)({enabled:e.length>0,queryKey:["fields",e.toString()],initialData:{},queryFn:async()=>await t.http.post(c.a.POST_QUERY_SOURCE_FIELDS,{body:JSON.stringify({indices:e})})});return{fields:n,isLoading:s}};var C=n(40);const w=({onClose:e})=>{const t=Object(u.a)(),{getValues:n}=Object(a.useFormContext)(),d=n(c.b.indices),{fields:j}=F(d),p=Object(C.b)(j),{field:{onChange:x,value:b}}=Object(a.useController)({name:c.b.queryFields,defaultValue:p}),[m,g]=Object(o.useState)(b),{field:{onChange:y}}=Object(a.useController)({name:c.b.elasticsearchQuery});return Object(o.useEffect)((()=>{null==t||t.load(r.a.viewQueryFlyoutOpened)}),[t]),Object(O.jsx)(s.EuiFlyout,{ownFocus:!0,onClose:e,size:"l"},Object(O.jsx)(s.EuiFlyoutHeader,{hasBorder:!0},Object(O.jsx)(s.EuiTitle,{size:"m"},Object(O.jsx)("h2",null,Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewQuery.flyout.title",defaultMessage:"Customize your Elasticsearch query"}))),Object(O.jsx)(s.EuiSpacer,{size:"s"}),Object(O.jsx)(s.EuiText,{color:"subdued"},Object(O.jsx)("p",null,Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewQuery.flyout.description",defaultMessage:"This query will be used to search your indices. Customize by choosing which fields in your Elasticsearch documents to search."})," ",Object(O.jsx)(s.EuiLink,{href:_.a.retrievalOptimize,target:"_blank","data-test-subj":"query-optimize-documentation-link"},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewQuery.flyout.learnMoreQueryOptimizeLink",defaultMessage:"Learn more."}))))),Object(O.jsx)(s.EuiFlyoutBody,null,Object(O.jsx)(s.EuiFlexGroup,null,Object(O.jsx)(s.EuiFlexItem,{grow:6},Object(O.jsx)(s.EuiCodeBlock,{language:"json",fontSize:"m",paddingSize:"m",lineNumbers:!0,"data-test-subj":"ViewElasticsearchQueryResult"},JSON.stringify(Object(C.a)(m,j),null,2))),Object(O.jsx)(s.EuiFlexItem,{grow:3},Object(O.jsx)(s.EuiFlexGroup,{direction:"column",gutterSize:"s"},Object(O.jsx)(s.EuiText,null,Object(O.jsx)("h5",null,Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewQuery.flyout.table.title",defaultMessage:"Fields to search (per index)"}))),Object.entries(j).map((([e,n])=>Object(O.jsx)(s.EuiFlexItem,{grow:!1,key:e},Object(O.jsx)(s.EuiPanel,{grow:!1,hasShadow:!1,hasBorder:!0},Object(O.jsx)(s.EuiAccordion,{id:e,initialIsOpen:!0,buttonContent:Object(O.jsx)(s.EuiText,null,Object(O.jsx)("h5",null,e))},Object(O.jsx)(s.EuiSpacer,{size:"s"}),Object(O.jsx)(s.EuiSelectable,{"aria-label":"Select query fields","data-test-subj":`queryFieldsSelectable_${e}`,options:[...n.elser_query_fields,...n.dense_vector_query_fields,...n.bm25_query_fields].map(((t,n)=>{const o=((e,t)=>m[e].includes(t))(e,"string"==typeof t?t:t.field);return{label:"string"==typeof t?t:t.field,prepend:Object(O.jsx)(s.EuiCheckbox,{id:`checkbox_${n}`,checked:o,onChange:()=>{}}),checked:o?"on":void 0}})),listProps:{bordered:!1,showIcons:!1},onChange:n=>((e,n)=>{const s=n.filter((e=>"on"===e.checked)).map((e=>e.label));g({...m,[e]:s}),null==t||t.count(r.a.viewQueryFieldsUpdated,s.length)})(e,n)},(e=>e)),n.skipped_fields>0&&Object(O.jsx)(i.a.Fragment,null,Object(O.jsx)(s.EuiSpacer,{size:"m"}),Object(O.jsx)(s.EuiFlexGroup,null,Object(O.jsx)(s.EuiFlexItem,null,Object(O.jsx)(s.EuiText,{size:"s",color:"subdued","data-test-subj":`skipped_fields_${e}`},Object(O.jsx)(s.EuiIcon,{type:"eyeClosed"})," ",Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewQuery.flyout.hiddenFields",defaultMessage:"{skippedFields} fields are hidden.",values:{skippedFields:n.skipped_fields}}))),Object(O.jsx)(s.EuiFlexItem,{grow:!1},Object(O.jsx)(s.EuiLink,{href:_.a.hiddenFields,target:"_blank","data-test-subj":"hidden-fields-documentation-link"},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewQuery.flyout.learnMoreLink",defaultMessage:"Learn more."})))))))))))))),Object(O.jsx)(s.EuiFlyoutFooter,null,Object(O.jsx)(s.EuiFlexGroup,{justifyContent:"spaceBetween"},Object(O.jsx)(s.EuiFlexItem,{grow:!1},Object(O.jsx)(s.EuiButtonEmpty,{iconType:"cross",onClick:e,flush:"left"},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewQuery.flyout.closeButton",defaultMessage:"Close"}))),Object(O.jsx)(s.EuiFlexItem,{grow:!1},Object(O.jsx)(s.EuiButton,{onClick:()=>{x(m),y(Object(C.a)(m,j)),e();const n=((e,t)=>Object.entries(t).map((([t,n])=>{const s=e[t];let o="";return n.some((e=>s.bm25_query_fields.includes(e)))&&(o="BM25"),n.some((e=>s.dense_vector_query_fields.find((t=>t.field===e))))&&(o+=(o?"_":"")+"DENSE"),n.some((e=>s.elser_query_fields.find((t=>t.field===e))))&&(o+=(o?"_":"")+"SPARSE"),o})))(j,m);n.forEach((e=>null==t?void 0:t.click(`${r.a.viewQuerySaved}_${e}`)))},fill:!0},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewQuery.flyout.saveButton",defaultMessage:"Save changes"}))))))},k=()=>{const[e,t]=Object(o.useState)(!1),{watch:n}=Object(a.useFormContext)(),r=n(c.b.indices);return Object(O.jsx)(i.a.Fragment,null,e&&Object(O.jsx)(w,{onClose:()=>t(!1)}),Object(O.jsx)(s.EuiButtonEmpty,{onClick:()=>t(!0),disabled:0===(null==r?void 0:r.length)},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.viewQuery.actionButtonLabel",defaultMessage:"View query"})))};var v=n(6);const S=({onClose:e})=>{const t=Object(u.a)(),{getValues:n}=Object(a.useFormContext)(),i=n(c.b.indices),{fields:d}=F(i),j=Object(C.c)(d),{field:{onChange:p,value:x}}=Object(a.useController)({name:c.b.docSize}),[b,m]=Object(o.useState)(x),{field:{onChange:g,value:y}}=Object(a.useController)({name:c.b.sourceFields,defaultValue:j}),[h,f]=Object(o.useState)(y);return Object(o.useEffect)((()=>{null==t||t.load(r.a.editContextFlyoutOpened)}),[t]),Object(O.jsx)(s.EuiFlyout,{ownFocus:!0,onClose:e,size:"s"},Object(O.jsx)(s.EuiFlyoutHeader,{hasBorder:!0},Object(O.jsx)(s.EuiTitle,{size:"m"},Object(O.jsx)("h2",null,Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.editContext.flyout.title",defaultMessage:"Edit context"}))),Object(O.jsx)(s.EuiSpacer,{size:"s"}),Object(O.jsx)(s.EuiText,{color:"subdued"},Object(O.jsx)("p",null,Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.editContext.flyout.description",defaultMessage:"Context is the information you provide to the LLM, by selecting fields from your Elasticsearch documents. Optimize context for better results."}),Object(O.jsx)(s.EuiLink,{href:_.a.context,target:"_blank","data-test-subj":"context-optimization-documentation-link"},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.editContext.flyout.learnMoreLink",defaultMessage:" Learn more."}))))),Object(O.jsx)(s.EuiFlyoutBody,null,Object(O.jsx)(s.EuiFlexGroup,null,Object(O.jsx)(s.EuiFlexItem,{grow:3},Object(O.jsx)(s.EuiFlexGroup,{direction:"column",gutterSize:"l"},Object(O.jsx)(s.EuiFlexItem,{grow:!1},Object(O.jsx)(s.EuiFormRow,{label:v.i18n.translate("xpack.searchPlayground.editContext.flyout.docsRetrievedCount",{defaultMessage:"Number of documents sent to LLM"})},Object(O.jsx)(s.EuiSelect,{options:[{value:1,text:"1"},{value:3,text:"3"},{value:5,text:"5"},{value:10,text:"10"}],value:b,onChange:e=>{null==t||t.click(r.a.editContextDocSizeChanged),m(Number(e.target.value))}}))),Object(O.jsx)(s.EuiFlexItem,null,Object(O.jsx)(s.EuiFlexGroup,{direction:"column",gutterSize:"m"},Object(O.jsx)(s.EuiFlexItem,null,Object(O.jsx)(s.EuiText,null,Object(O.jsx)("h5",null,Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.editContext.flyout.table.title",defaultMessage:"Select fields"})))),Object.entries(d).map((([e,n])=>{var o;return Object(O.jsx)(s.EuiFlexItem,{grow:!1,key:e},Object(O.jsx)(s.EuiFormRow,{label:e},Object(O.jsx)(s.EuiSuperSelect,{"data-test-subj":`contextFieldsSelectable_${e}`,options:n.source_fields.map((e=>({value:e,inputDisplay:e}))),valueOfSelected:null===(o=h[e])||void 0===o?void 0:o[0],onChange:n=>((e,n)=>{f({...h,[e]:[n]}),null==t||t.click(r.a.editContextFieldToggled)})(e,n)})))})))))))),Object(O.jsx)(s.EuiFlyoutFooter,null,Object(O.jsx)(s.EuiFlexGroup,{justifyContent:"spaceBetween"},Object(O.jsx)(s.EuiFlexItem,{grow:!1},Object(O.jsx)(s.EuiButtonEmpty,{iconType:"cross",onClick:e,flush:"left"},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.editContext.flyout.closeButton",defaultMessage:"Close"}))),Object(O.jsx)(s.EuiFlexItem,{grow:!1},Object(O.jsx)(s.EuiButton,{onClick:()=>{null==t||t.click(r.a.editContextSaved),g(h),p(b),e()},fill:!0},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.editContext.flyout.saveButton",defaultMessage:"Save changes"}))))))},M=()=>{const{watch:e}=Object(a.useFormContext)(),[t,n]=Object(o.useState)(!1),c=e("indices");return Object(O.jsx)(i.a.Fragment,null,t&&Object(O.jsx)(S,{onClose:()=>n(!1)}),Object(O.jsx)(s.EuiButtonEmpty,{onClick:()=>n(!0),disabled:0===(null==c?void 0:c.length)},Object(O.jsx)(l.FormattedMessage,{id:"xpack.searchPlayground.editContext.actionButtonLabel",defaultMessage:"Edit context"})))},P=()=>Object(O.jsx)(s.EuiFlexGroup,{gutterSize:"s","data-test-subj":"playground-header-actions"},Object(O.jsx)(M,null),Object(O.jsx)(k,null),Object(O.jsx)(f,null))}}]);