"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPlaygroundPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _events = require("./analytics/events");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchPlaygroundPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core) {
    this.logger.debug('searchPlayground: Setup');
    const router = core.http.createRouter();
    (0, _routes.defineRoutes)({
      router,
      logger: this.logger,
      getStartServices: core.getStartServices
    });
    this.registerAnalyticsEvents(core);
    return {};
  }
  start(core) {
    return {};
  }
  registerAnalyticsEvents(core) {
    core.analytics.registerEventType(_events.sendMessageEvent);
  }
  stop() {}
}
exports.SearchPlaygroundPlugin = SearchPlaygroundPlugin;