"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _reactHookForm = require("react-hook-form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryClient = new _reactQuery.QueryClient({});
const PlaygroundProvider = ({
  children
}) => {
  const form = (0, _reactHookForm.useForm)({
    defaultValues: {
      prompt: 'You are an assistant for question-answering tasks.',
      doc_size: 3,
      source_fields: {},
      indices: []
    }
  });
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, form, children));
};
exports.PlaygroundProvider = PlaygroundProvider;