"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLLMsModels = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/stack-connectors-plugin/public/common");
var _react = require("react");
var _types = require("../../common/types");
var _use_load_connectors = require("./use_load_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapLlmToModels = {
  [_types.LLMs.openai]: {
    icon: _common.OpenAILogo,
    getModels: (connectorName, includeName) => [{
      model: 'gpt-3.5-turbo',
      limit: 16385
    }, {
      model: 'gpt-4o',
      limit: 128000
    }, {
      model: 'gpt-4-turbo',
      limit: 128000
    }].map(model => ({
      label: `${model.model} ${includeName ? `(${connectorName})` : ''}`,
      value: model.model,
      promptTokenLimit: model.limit
    }))
  },
  [_types.LLMs.openai_azure]: {
    icon: _common.OpenAILogo,
    getModels: (connectorName, includeName) => [{
      label: _i18n.i18n.translate('xpack.searchPlayground.openAIAzureModel', {
        defaultMessage: 'Azure OpenAI {name}',
        values: {
          name: includeName ? `(${connectorName})` : ''
        }
      })
    }]
  },
  [_types.LLMs.bedrock]: {
    icon: _common.BedrockLogo,
    getModels: () => [{
      label: 'Claude 3 Haiku',
      value: 'anthropic.claude-3-haiku-20240307-v1:0',
      promptTokenLimit: 200000
    }, {
      label: 'Claude 3 Sonnet',
      value: 'anthropic.claude-3-haiku-20240307-v1:0',
      promptTokenLimit: 200000
    }]
  }
};
const useLLMsModels = () => {
  const {
    data: connectors
  } = (0, _use_load_connectors.useLoadConnectors)();
  const mapConnectorTypeToCount = (0, _react.useMemo)(() => connectors === null || connectors === void 0 ? void 0 : connectors.reduce((result, connector) => ({
    ...result,
    [connector.type]: (result[connector.type] || 0) + 1
  }), {}), [connectors]);
  return (0, _react.useMemo)(() => (connectors === null || connectors === void 0 ? void 0 : connectors.reduce((result, connector) => {
    const llmParams = mapLlmToModels[connector.type];
    if (!llmParams) {
      return result;
    }
    const showConnectorName = Number(mapConnectorTypeToCount === null || mapConnectorTypeToCount === void 0 ? void 0 : mapConnectorTypeToCount[connector.type]) > 1;
    return [...result, ...llmParams.getModels(connector.name, false).map(({
      label,
      value,
      promptTokenLimit
    }) => ({
      id: (connector === null || connector === void 0 ? void 0 : connector.id) + label,
      name: label,
      value,
      connectorType: connector.type,
      connectorName: connector.name,
      showConnectorName,
      icon: llmParams.icon,
      disabled: !connector,
      connectorId: connector.id,
      promptTokenLimit
    }))];
  }, [])) || [], [connectors, mapConnectorTypeToCount]);
};
exports.useLLMsModels = useLLMsModels;