"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PY_LANG_CLIENT = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _prompt = require("../../../../common/prompt");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PY_LANG_CLIENT = (formValues, clientDetails) => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  language: "py",
  isCopyable: true,
  overflowHeight: "100%"
}, `## Install the required packages
## pip install -qU elasticsearch openai

import os
from elasticsearch import Elasticsearch
from openai import OpenAI

${clientDetails}

openai_client = OpenAI(
    api_key=os.environ["OPENAI_API_KEY"],
)

index_source_fields = ${JSON.stringify(formValues.source_fields, null, 4)}

def get_elasticsearch_results(query):
    es_query = ${(0, _utils.getESQuery)({
  ...formValues.elasticsearch_query,
  size: formValues.doc_size
})}

    result = es_client.search(index="${formValues.indices.join(',')}", body=es_query)
    return result["hits"]["hits"]

def create_openai_prompt(question, results):
    context = ""
    for hit in results:
      source_field = index_source_fields.get(hit["_index"])[0]
      hit_context = hit["_source"][source_field]
      context += f"{hit_context}\\n"

    prompt = f"""${(0, _prompt.Prompt)(formValues.prompt, {
  context: true,
  citations: formValues.citations,
  type: 'openai'
})}"""

    return prompt

def generate_openai_completion(user_prompt):
    response = openai_client.chat.completions.create(
        model="gpt-3.5-turbo",
        messages=[
            {"role": "system", "content": "You are an assistant for question-answering tasks."},
            {"role": "user", "content": user_prompt},
        ]
    )

    return response.choices[0].message.content

if __name__ == "__main__":
    question = "my question"
    elasticsearch_results = get_elasticsearch_results(question)
    context_prompt = create_openai_prompt(question, elasticsearch_results)
    openai_completion = generate_openai_completion(context_prompt)
    print(openai_completion)

`);
exports.PY_LANG_CLIENT = PY_LANG_CLIENT;