"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummarizationPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_llms_models = require("../../hooks/use_llms_models");
var _include_citations_field = require("./include_citations_field");
var _instructions_field = require("./instructions_field");
var _types = require("../../types");
var _summarization_model = require("./summarization_model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SummarizationPanel = () => {
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  const models = (0, _use_llms_models.useLLMsModels)();
  const defaultModel = models.find(model => !model.disabled);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: _types.ChatFormFields.summarizationModel,
    defaultValue: defaultModel,
    rules: {
      required: true
    },
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_summarization_model.SummarizationModel, {
      selectedModel: field.value,
      onSelect: model => field.onChange(model),
      models: models
    })
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: _types.ChatFormFields.prompt,
    control: control,
    rules: {
      required: true
    },
    defaultValue: "You are an assistant for question-answering tasks.",
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_instructions_field.InstructionsField, {
      value: field.value,
      onChange: field.onChange
    })
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: _types.ChatFormFields.citations,
    control: control,
    defaultValue: true,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_include_citations_field.IncludeCitationsField, {
      checked: field.value,
      onChange: field.onChange
    })
  }));
};
exports.SummarizationPanel = SummarizationPanel;