"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartNewChat = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _use_usage_tracker = require("../hooks/use_usage_tracker");
var _use_load_connectors = require("../hooks/use_load_connectors");
var _sources_panel_for_start_chat = require("./sources_panel/sources_panel_for_start_chat");
var _set_up_connector_panel_for_start_chat = require("./set_up_connector_panel_for_start_chat");
var _types = require("../types");
var _constants = require("../analytics/constants");
var _use_source_indices_field = require("../hooks/use_source_indices_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maxWidthPage = 640;
const StartNewChat = ({
  onStartClick
}) => {
  var _watch;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data: connectors
  } = (0, _use_load_connectors.useLoadConnectors)();
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const index = (0, _react.useMemo)(() => searchParams.get('default-index'), [searchParams]);
  const {
    addIndex
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  (0, _react.useEffect)(() => {
    if (index) {
      addIndex(index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [index]);
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.startNewChatPageLoaded);
  }, [usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    className: "eui-yScroll",
    "data-test-subj": "startChatPage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      height: 'fit-content',
      padding: `${euiTheme.size.xxl} ${euiTheme.size.l}`,
      maxWidth: maxWidthPage,
      boxSizing: 'content-box'
    },
    direction: "column",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "startNewChatTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.startNewChat.title",
    defaultMessage: "Start a new chat"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "discuss",
    size: "xl"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.startNewChat.description",
    defaultMessage: "Combine your Elasticsearch data with the power of large language models for retrieval augmented generation (RAG). Use the UI to view and edit the Elasticsearch queries used to search your data, then download the code to integrate into your own application."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_set_up_connector_panel_for_start_chat.SetUpConnectorPanelForStartChat, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sources_panel_for_start_chat.SourcesPanelForStartChat, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "arrowRight",
    iconSide: "right",
    "data-test-subj": "startChatButton",
    disabled: !((_watch = watch(_types.ChatFormFields.indices, [])) !== null && _watch !== void 0 && _watch.length) || !Object.keys(connectors || {}).length || !watch(_types.ChatFormFields.elasticsearchQuery, ''),
    onClick: onStartClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.startNewChat.startBtn",
    defaultMessage: "Start"
  })))));
};
exports.StartNewChat = StartNewChat;